/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.dialogarena.common.web.selftest;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import no.nav.sbl.dialogarena.common.web.selftest.SelfTestStatus;
import no.nav.sbl.dialogarena.common.web.selftest.domain.Selftest;
import no.nav.sbl.dialogarena.common.web.selftest.domain.SelftestResult;
import no.nav.sbl.dialogarena.types.Pingable;
import no.nav.sbl.util.EnvironmentUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfTestService {
    private static final Logger log = LoggerFactory.getLogger(SelfTestService.class);
    private final List<Pingable> pingables;
    private volatile List<SelftestResult> lastResult;
    private volatile long lastResultTime;

    public SelfTestService(Collection<? extends Pingable> pingables) {
        this.pingables = new ArrayList<Pingable>(pingables);
    }

    private SelfTestStatus getAggregertStatus() {
        boolean harKritiskFeil = this.lastResult.stream().anyMatch(SelfTestService::harKritiskFeil);
        boolean harFeil = this.lastResult.stream().anyMatch(SelftestResult::harFeil);
        if (harKritiskFeil) {
            return SelfTestStatus.ERROR;
        }
        if (harFeil) {
            return SelfTestStatus.WARNING;
        }
        return SelfTestStatus.OK;
    }

    private static SelftestResult doPing(Pingable pingable) {
        long startTime = System.currentTimeMillis();
        Pingable.Ping ping = SelfTestService.performPing(pingable);
        long responseTime = System.currentTimeMillis() - startTime;
        Pingable.Ping.PingMetadata metadata = Optional.ofNullable(ping.getMetadata()).orElseGet(SelfTestService::unknownMetadata);
        if (!ping.erVellykket() && !ping.erAvskrudd()) {
            log.warn("Feil ved SelfTest av " + metadata.getEndepunkt(), ping.getFeil());
        }
        return SelftestResult.builder().id(metadata.getId()).responseTime(responseTime).endpoint(metadata.getEndepunkt()).description(metadata.getBeskrivelse()).errorMessage(ping.getFeilmelding()).critical(metadata.isKritisk()).result(SelfTestService.computePingResult(ping)).stacktrace(Optional.ofNullable(ping.getFeil()).map(ExceptionUtils::getStackTrace).orElse(null)).build();
    }

    private static Pingable.Ping performPing(Pingable pingable) {
        try {
            return Optional.ofNullable(pingable.ping()).orElseGet(() -> SelfTestService.unknownPingResult(pingable));
        }
        catch (Exception e) {
            String className = pingable.getClass().getName();
            return Pingable.Ping.feilet((Pingable.Ping.PingMetadata)new Pingable.Ping.PingMetadata(className, className, className, true), (Throwable)e);
        }
    }

    private static Pingable.Ping unknownPingResult(Pingable pingable) {
        return Pingable.Ping.feilet((Pingable.Ping.PingMetadata)SelfTestService.unknownMetadata(), (Throwable)new IllegalStateException(pingable.toString()));
    }

    private static Pingable.Ping.PingMetadata unknownMetadata() {
        return new Pingable.Ping.PingMetadata("unknown_ping", "?", "?", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selftest selfTest() {
        long requestTime = System.currentTimeMillis();
        SelfTestService selfTestService = this;
        synchronized (selfTestService) {
            if (requestTime > this.lastResultTime) {
                this.lastResult = this.pingables.stream().map(SelfTestService::doPing).collect(Collectors.toList());
                this.lastResultTime = System.currentTimeMillis();
            }
        }
        return Selftest.builder().application(EnvironmentUtils.getApplicationName().orElse("?")).version(EnvironmentUtils.getApplicationVersion().orElse("?")).timestamp(LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME)).aggregateResult(this.getAggregertStatus()).checks(this.lastResult).build();
    }

    private static SelfTestStatus computePingResult(Pingable.Ping ping) {
        if (ping.erAvskrudd()) {
            return SelfTestStatus.DISABLED;
        }
        return ping.harFeil() ? SelfTestStatus.ERROR : SelfTestStatus.OK;
    }

    private static boolean harKritiskFeil(SelftestResult selftestResult) {
        return selftestResult.harFeil() && selftestResult.isCritical();
    }
}

