/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.dialogarena.common.suspend;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthenticationFilter
implements Filter {
    public static final String AUTH_PROPERTY_NAME = "authProperty";
    public static final String DEFAULT_AUTH_PROPERTY = "suspender";
    private String username = "";
    private String password = "";
    private String realm = "Protected";

    public void init(FilterConfig filterConfig) throws ServletException {
        String authProperty = filterConfig.getInitParameter(AUTH_PROPERTY_NAME);
        authProperty = authProperty != null ? authProperty : DEFAULT_AUTH_PROPERTY;
        this.username = System.getProperty(authProperty + ".username");
        this.password = System.getProperty(authProperty + ".password");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            String basic;
            StringTokenizer st = new StringTokenizer(authHeader);
            if (st.hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                try {
                    String credentials = new String(Base64.decodeBase64((String)st.nextToken()));
                    int p = credentials.indexOf(":");
                    if (p != -1) {
                        String _username = credentials.substring(0, p).trim();
                        String _password = credentials.substring(p + 1).trim();
                        if (!this.username.equals(_username) || !this.password.equals(_password)) {
                            this.unauthorized(response, "Bad credentials");
                        }
                        filterChain.doFilter(servletRequest, servletResponse);
                    }
                    this.unauthorized(response, "Invalid authentication token");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Couldn't retrieve authentication", e);
                }
            }
        } else {
            this.unauthorized(response);
        }
    }

    public void destroy() {
    }

    private void unauthorized(HttpServletResponse response, String message) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        response.sendError(401, message);
    }

    private void unauthorized(HttpServletResponse response) throws IOException {
        this.unauthorized(response, "Unauthorized");
    }
}

