/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.dialogarena.common.suspend;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendServlet
extends HttpServlet {
    public static final String SHUTDOWN_TIME = "shutdownTimeMs";
    public static final long DEFAULT_SIGNAL_READY_FOR_SHUTDOWN_IN_MS = 3000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SuspendServlet.class);
    private static ApplicationStatus status = ApplicationStatus.RUNNING;
    private long signalReadyForShutdownInMs;

    public void init() throws ServletException {
        String shutdownTime = this.getInitParameter(SHUTDOWN_TIME);
        this.signalReadyForShutdownInMs = shutdownTime != null ? Long.parseLong(shutdownTime) : 3000L;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info("[GET] Suspend-request mottatt - appen er i status {} ", (Object)status);
        if (status.equals((Object)ApplicationStatus.SUSPENDED)) {
            response.setStatus(200);
        } else {
            response.sendError(503, String.format("Appen er i status %s", new Object[]{status}));
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) {
        if (status.equals((Object)ApplicationStatus.RUNNING)) {
            LOGGER.info("[PUT] Suspend-request mottat - starter \u00e5 klargj\u00f8re for shutdown");
            status = ApplicationStatus.TO_BE_SUSPENDED;
            this.scheduleReadyForShutdown(this.signalReadyForShutdownInMs);
        }
        response.setStatus(200);
    }

    private void scheduleReadyForShutdown(final long waitForShutdownMs) {
        Timer timer = new Timer("TimerTask - Venter ut eksisterende connections");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                status = ApplicationStatus.SUSPENDED;
                LOGGER.info("Ventet {} ms - suspended og klar for shutdown", (Object)waitForShutdownMs);
            }
        }, waitForShutdownMs);
    }

    public static boolean isRunning() {
        return status.equals((Object)ApplicationStatus.RUNNING);
    }

    public static enum ApplicationStatus {
        RUNNING,
        TO_BE_SUSPENDED,
        SUSPENDED;

    }
}

