/*
 * Decompiled with CFR 0.152.
 */
package no.nav.familie.http.client;

import java.net.http.HttpRequest;
import java.time.Duration;
import no.nav.familie.http.client.IdUtils;
import no.nav.familie.http.client.NavHttpHeaders;
import org.slf4j.MDC;

public final class HttpRequestUtil {
    static final String CALL_ID = "callId";

    private HttpRequestUtil() {
    }

    public static HttpRequest.Builder createRequest(String authorizationHeader) {
        return HttpRequest.newBuilder().header("Authorization", authorizationHeader).header(NavHttpHeaders.NAV_CALLID.asString(), HttpRequestUtil.hentEllerOpprettCallId()).timeout(Duration.ofSeconds(30L));
    }

    private static String hentEllerOpprettCallId() {
        String callId = MDC.get((String)CALL_ID);
        if (callId == null) {
            return IdUtils.generateId();
        }
        return callId;
    }
}

