/*
 * Decompiled with CFR 0.152.
 */
package no.nav.familie.http.sts;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import no.nav.familie.http.client.HttpClientUtil;
import no.nav.familie.http.client.HttpRequestUtil;
import no.nav.familie.http.sts.AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsRestClient {
    private static final Logger log = LoggerFactory.getLogger(StsRestClient.class);
    private final HttpClient client;
    private final URI stsUrl;
    private final String stsUsername;
    private final String stsPassword;
    private ObjectMapper mapper;
    private AccessTokenResponse cachedToken;

    public StsRestClient(ObjectMapper mapper, URI stsUrl, String stsUsername, String stsPassword) {
        this.mapper = mapper;
        this.client = HttpClientUtil.create();
        this.stsUrl = stsUrl;
        this.stsUsername = stsUsername;
        this.stsPassword = stsPassword;
    }

    private static String basicAuth(String username, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    private boolean isTokenValid() {
        if (this.cachedToken == null) {
            return false;
        }
        log.debug("Tokenet l\u00f8per ut: {}. Tiden n\u00e5 er: {}", (Object)Instant.ofEpochMilli(this.cachedToken.getExpires_in()).atZone(ZoneId.systemDefault()).toLocalTime(), (Object)LocalTime.now(ZoneId.systemDefault()));
        return Instant.ofEpochMilli(this.cachedToken.getExpires_in()).atZone(ZoneId.systemDefault()).toLocalTime().minusMinutes(15L).isAfter(LocalTime.now(ZoneId.systemDefault()));
    }

    public String getSystemOIDCToken() {
        AccessTokenResponse accessTokenResponse;
        if (this.isTokenValid()) {
            log.info("Henter token fra cache");
            return this.cachedToken.getAccess_token();
        }
        log.info("Henter token fra STS");
        HttpRequest request = HttpRequestUtil.createRequest(StsRestClient.basicAuth(this.stsUsername, this.stsPassword)).uri(this.stsUrl).header("Content-Type", "application/json").timeout(Duration.ofSeconds(30L)).build();
        try {
            accessTokenResponse = (AccessTokenResponse)((CompletableFuture)((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(it -> {
                try {
                    return (AccessTokenResponse)this.mapper.readValue(it, AccessTokenResponse.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return "";
        }
        if (accessTokenResponse != null) {
            this.cachedToken = accessTokenResponse;
            return accessTokenResponse.getAccess_token();
        }
        return "";
    }
}

