/*
 * Decompiled with CFR 0.152.
 */
package no.nav.familie.http.azure;

import java.time.LocalTime;
import java.time.ZoneId;
import no.nav.familie.http.azure.AccessTokenDto;
import no.nav.familie.http.azure.AccessTokenRequestBody;
import no.nav.familie.http.azure.AzureAccessTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class AccessTokenClient {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenClient.class);
    private final String grantType = "client_credentials";
    private String aadAccessTokenUrl;
    private String clientId;
    private String clientSecret;
    private RestTemplate restTemplate;
    private AccessTokenDto cachedToken;

    public AccessTokenClient(String aadAccessTokenUrl, String clientId, String clientSecret, RestTemplate restTemplate) {
        this.aadAccessTokenUrl = aadAccessTokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.restTemplate = restTemplate;
    }

    private boolean isTokenValid() {
        if (this.cachedToken == null) {
            return false;
        }
        logger.debug("Tokenet l\u00f8per ut: {}. Tiden n\u00e5 er: {}", (Object)this.cachedToken.getExpires_on().atZone(ZoneId.systemDefault()).toLocalTime(), (Object)LocalTime.now(ZoneId.systemDefault()));
        return this.cachedToken.getExpires_on().atZone(ZoneId.systemDefault()).toLocalTime().minusMinutes(15L).isAfter(LocalTime.now(ZoneId.systemDefault()));
    }

    public AccessTokenDto getAccessToken(String resource) {
        if (this.isTokenValid()) {
            logger.debug("Henter token fra cache");
            return this.cachedToken;
        }
        logger.debug("Henter token fra azure");
        AccessTokenRequestBody accessTokenRequestBody = new AccessTokenRequestBody(this.clientId, resource, "client_credentials", this.clientSecret);
        HttpEntity httpEntity = new HttpEntity((Object)accessTokenRequestBody);
        try {
            ResponseEntity accessTokenResponse = this.restTemplate.exchange(this.aadAccessTokenUrl, HttpMethod.POST, httpEntity, AccessTokenDto.class, new Object[0]);
            if (accessTokenResponse.getStatusCode() == HttpStatus.OK) {
                AccessTokenDto accessToken = (AccessTokenDto)accessTokenResponse.getBody();
                if (accessToken != null) {
                    this.cachedToken = accessToken;
                    return accessToken;
                }
                logger.warn("Manglende token fra azure ad");
                throw new AzureAccessTokenException("Manglende token fra azure ad");
            }
            logger.warn("Kall mot azure ad for \u00e5 hente token feilet");
            throw new AzureAccessTokenException("Kall mot azure ad for \u00e5 hente token feilet");
        }
        catch (RestClientException e) {
            logger.warn("Kall mot azure ad for \u00e5 hente token feilet");
            throw new AzureAccessTokenException("Kall mot azure ad for \u00e5 hente token feilet", e);
        }
    }
}

