/*
 * Decompiled with CFR 0.152.
 */
package no.nav.familie.http.azure;

import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import no.nav.familie.http.azure.AccessTokenDto;
import no.nav.familie.http.azure.AzureAccessTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class AccessTokenClient {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenClient.class);
    private URI aadAccessTokenUrl;
    private String clientId;
    private String clientSecret;
    private RestTemplate restTemplate;
    private AccessTokenDto cachedToken;
    private LocalDateTime cachedTokenExpiresOn;

    public AccessTokenClient(URI aadAccessTokenUrl, String clientId, String clientSecret, RestTemplate restTemplate) {
        this.aadAccessTokenUrl = aadAccessTokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.restTemplate = restTemplate;
    }

    private boolean isTokenValid() {
        if (this.cachedToken == null) {
            return false;
        }
        logger.debug("Tokenet l\u00f8per ut: {}. Tiden n\u00e5 er: {}", (Object)this.cachedTokenExpiresOn, (Object)LocalDateTime.now(ZoneId.systemDefault()));
        return this.cachedTokenExpiresOn.minusMinutes(5L).isAfter(LocalDateTime.now(ZoneId.systemDefault()));
    }

    public AccessTokenDto getAccessToken(String scope) {
        if (this.isTokenValid()) {
            logger.debug("Henter token fra cache");
            return this.cachedToken;
        }
        logger.debug("Henter token fra azure");
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"client_id", (Object)this.clientId);
            body.add((Object)"scope", (Object)scope);
            body.add((Object)"grant_type", (Object)"client_credentials");
            body.add((Object)"client_secret", (Object)this.clientSecret);
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity accessTokenResponse = this.restTemplate.exchange(this.aadAccessTokenUrl, HttpMethod.POST, httpEntity, AccessTokenDto.class);
            if (accessTokenResponse.getStatusCode() == HttpStatus.OK) {
                AccessTokenDto accessToken = (AccessTokenDto)accessTokenResponse.getBody();
                if (accessToken != null) {
                    this.cachedToken = accessToken;
                    this.cachedTokenExpiresOn = LocalDateTime.now(ZoneId.systemDefault()).plusSeconds(accessToken.getExpires_in().intValue());
                    return accessToken;
                }
                logger.warn("Manglende token fra azure ad");
                throw new AzureAccessTokenException("Manglende token fra azure ad");
            }
            logger.warn("Kall mot azure ad for \u00e5 hente token feilet");
            throw new AzureAccessTokenException("Kall mot azure ad for \u00e5 hente token feilet");
        }
        catch (RestClientException e) {
            logger.warn("Kall mot azure ad for \u00e5 hente token feilet");
            throw new AzureAccessTokenException("Kall mot azure ad for \u00e5 hente token feilet", e);
        }
    }
}

