/*
 * Decompiled with CFR 0.152.
 */
package no.nav.familie.log.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.familie.log.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogFilter
implements Filter {
    public static final String CONSUMER_ID_HEADER_NAME = "Nav-Consumer-Id";
    public static final String PREFERRED_NAV_CALL_ID_HEADER_NAME = "Nav-Call-Id";
    public static final String[] NAV_CALL_ID_HEADER_NAMES = new String[]{"Nav-Call-Id", "Nav-CallId", "X-Correlation-Id"};
    private static final Logger log = LoggerFactory.getLogger(LogFilter.class);
    private static final String RANDOM_USER_ID_COOKIE_NAME = "RUIDC";
    private static final int ONE_MONTH_IN_SECONDS = 2592000;
    private final Supplier<Boolean> exposeErrorDetails;
    private final String serverName;

    public LogFilter() {
        this(() -> false, null);
    }

    public LogFilter(Supplier<Boolean> exposeErrorDetails, String serverName) {
        this.exposeErrorDetails = exposeErrorDetails;
        this.serverName = serverName;
    }

    public static String resolveCallId(HttpServletRequest httpServletRequest) {
        return Arrays.stream(NAV_CALL_ID_HEADER_NAMES).map(arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0)).filter(it -> it != null && !it.isEmpty()).findFirst().orElseGet(IdUtils::generateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String userId = this.resolveUserId(httpServletRequest);
        if (userId == null || userId.isEmpty()) {
            this.generateUserIdCookie(httpServletResponse);
        }
        String consumerId = httpServletRequest.getHeader(CONSUMER_ID_HEADER_NAME);
        String callId = LogFilter.resolveCallId(httpServletRequest);
        MDC.put((String)"callId", (String)callId);
        MDC.put((String)"userId", (String)userId);
        MDC.put((String)"consumerId", (String)consumerId);
        MDC.put((String)"requestId", (String)IdUtils.generateId());
        httpServletResponse.setHeader(PREFERRED_NAV_CALL_ID_HEADER_NAME, callId);
        if (this.serverName != null) {
            httpServletResponse.setHeader("Server", this.serverName);
        }
        try {
            this.filterWithErrorHandling(httpServletRequest, httpServletResponse, filterChain);
        }
        finally {
            MDC.remove((String)"callId");
            MDC.remove((String)"userId");
            MDC.remove((String)"consumerId");
            MDC.remove((String)"requestId");
        }
    }

    private void generateUserIdCookie(HttpServletResponse httpServletResponse) {
        String userId = IdUtils.generateId();
        Cookie cookie = new Cookie(RANDOM_USER_ID_COOKIE_NAME, userId);
        cookie.setPath("/");
        cookie.setMaxAge(2592000);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        httpServletResponse.addCookie(cookie);
    }

    private void filterWithErrorHandling(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        block3: {
            try {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (httpServletResponse.isCommitted()) {
                    log.error("failed with status={}", (Object)httpServletResponse.getStatus());
                    throw e;
                }
                httpServletResponse.setStatus(500);
                if (!this.exposeErrorDetails.get().booleanValue()) break block3;
                e.printStackTrace(httpServletResponse.getWriter());
            }
        }
    }

    public String resolveUserId(HttpServletRequest httpServletRequest) {
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!RANDOM_USER_ID_COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.doFilterInternal((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
    }

    public void destroy() {
    }
}

