/*
 * Decompiled with CFR 0.152.
 */
package no.nav.familie.sikkerhet;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.exceptions.JwtTokenValidatorException;
import no.nav.security.token.support.core.jwt.JwtTokenClaims;
import org.springframework.stereotype.Component;

@Component
public class OIDCUtil {
    private final TokenValidationContextHolder ctxHolder;

    public OIDCUtil(TokenValidationContextHolder ctxHolder) {
        this.ctxHolder = ctxHolder;
    }

    public String getSubject() {
        return Optional.ofNullable(this.claimSet()).map(JwtTokenClaims::getSubject).orElse(null);
    }

    public String autentisertBruker() {
        return Optional.ofNullable(this.getSubject()).orElseThrow(() -> new JwtTokenValidatorException("Fant ikke subject", this.getExpiryDate()));
    }

    public String getNavIdent() {
        return Optional.ofNullable(this.claimSet()).map(c -> c.get("NAVident")).map(Object::toString).orElseThrow(() -> new JwtTokenValidatorException("Fant ikke NAVident", this.getExpiryDate()));
    }

    public List<String> getGroups() {
        return Optional.ofNullable(this.claimSet()).map(c -> c.get("groups")).stream().map(Object::toString).collect(Collectors.toList());
    }

    public JwtTokenClaims claimSet() {
        return Optional.ofNullable(this.context()).map(s -> s.getClaims("azuread")).orElse(null);
    }

    private TokenValidationContext context() {
        return Optional.ofNullable(this.ctxHolder.getTokenValidationContext()).orElse(null);
    }

    public Date getExpiryDate() {
        return Optional.ofNullable(this.claimSet()).map(c -> c.get("exp")).map(this::getDateClaim).orElse(null);
    }

    public Date getDateClaim(Object value) {
        if (value instanceof Date) {
            return (Date)Date.class.cast(value);
        }
        if (value instanceof Number) {
            return new Date(((Number)Number.class.cast(value)).longValue() * 1000L);
        }
        return null;
    }
}

