package no.nav.melosys.domain.kodeverk;

import javax.persistence.Converter;

public enum  Aktoersroller implements InterntKodeverkTabell<Aktoersroller> {

    BRUKER("BRUKER", "Bruker"),
	ARBEIDSGIVER("ARBEIDSGIVER", "Arbeidsgiver"),
	REPRESENTANT("REPRESENTANT", "Fullmektig"),
	MYNDIGHET("MYNDIGHET", "Trygdemyndighet");

    private String kode;
    private String beskrivelse;

    Aktoersroller(String kode, String beskrivelse) {
        this.kode = kode;
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return kode;
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }

    @Converter
    public static class DbKonverterer extends InterntKodeverkTabell.DbKonverterer<Aktoersroller> {
        @Override
        protected Aktoersroller[] getLovligeVerdier() {
            return Aktoersroller.values();
        }
    }

}
