package no.nav.melosys.domain.kodeverk;

import javax.persistence.Converter;

public enum  Saksstatuser implements InterntKodeverkTabell<Saksstatuser> {

    OPPRETTET("OPPRETTET", "Saken er opprettet"),
	LOVVALG_AVKLART("LOVVALG_AVKLART", "Lovvalget er avklart"),
	AVSLUTTET("AVSLUTTET", "Saken er avsluttet"),
	HENLAGT("HENLAGT", "Saken er henlagt"),
	HENLAGT_BORTFALT("HENLAGT_BORTFALT", "Saken er henlagt som bortfalt i Melosys");

    private String kode;
    private String beskrivelse;

    Saksstatuser(String kode, String beskrivelse) {
        this.kode = kode;
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return kode;
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }

    @Converter
    public static class DbKonverterer extends InterntKodeverkTabell.DbKonverterer<Saksstatuser> {
        @Override
        protected Saksstatuser[] getLovligeVerdier() {
            return Saksstatuser.values();
        }
    }

}
