package no.nav.melosys.domain.kodeverk;

import javax.persistence.Converter;

public enum  Behandlingstyper implements InterntKodeverkTabell<Behandlingstyper> {

    SOEKNAD("SOEKNAD", "Søknad"),
	KLAGE("KLAGE", "Klage"),
	ANKE("ANKE", "Anke"),
	UNNTAK_FRA_MEDLEMSKAP("UNNTAK_FRA_MEDLEMSKAP", "Registrering av unntak"),
	NORGE_UTPEKT("NORGE_UTPEKT", "Behandle at Norge er utpekt"),
	PAASTAND_UTL("PAASTAND_UTL", "Behandle påstand fra utlandet"),
	NY_VURDERING("NY_VURDERING", "Behandle ny vurdering"),
	ENDRET_PERIODE("ENDRET_PERIODE", "Behandle forkortet periode");

    private String kode;
    private String beskrivelse;

    Behandlingstyper(String kode, String beskrivelse) {
        this.kode = kode;
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return kode;
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }

    @Converter
    public static class DbKonverterer extends InterntKodeverkTabell.DbKonverterer<Behandlingstyper> {
        @Override
        protected Behandlingstyper[] getLovligeVerdier() {
            return Behandlingstyper.values();
        }
    }

}
