package no.nav.melosys.domain.kodeverk;

import javax.persistence.Converter;

public enum  Sakstyper implements InterntKodeverkTabell<Sakstyper> {

    EU_EOS("EU_EOS", "EU/EØS"),
	TRYGDEAVTALE("TRYGDEAVTALE", "Trygdeavtale"),
	FTRL("FTRL", "Folketrygdloven");

    private String kode;
    private String beskrivelse;

    Sakstyper(String kode, String beskrivelse) {
        this.kode = kode;
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return kode;
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }

    @Converter
    public static class DbKonverterer extends InterntKodeverkTabell.DbKonverterer<Sakstyper> {
        @Override
        protected Sakstyper[] getLovligeVerdier() {
            return Sakstyper.values();
        }
    }

}
