package no.nav.melosys.domain.kodeverk;

import javax.persistence.Converter;

public enum  Behandlingsresultattyper implements InterntKodeverkTabell<Behandlingsresultattyper> {

    FASTSATT_LOVVALGSLAND("FASTSATT_LOVVALGSLAND", "Lovvalgsland er fastsatt"),
	AVSLAG_MANGLENDE_OPPL("AVSLAG_MANGLENDE_OPPL", "Avslått pga manglende opplysninger"),
	FORELOEPIG_FASTSATT_LOVVALGSLAND("FORELOEPIG_FASTSATT_LOVVALGSLAND", "Lovvalgsland er foreløpig fastsatt"),
	HENLEGGELSE("HENLEGGELSE", "Saken er henlagt"),
	ANMODNING_OM_UNNTAK("ANMODNING_OM_UNNTAK", "Anmodning om unntak"),
	IKKE_FASTSATT("IKKE_FASTSATT", "Ikke fastsatt"),
	REGISTRERT_UNNTAK("REGISTRERT_UNNTAK", "Om unntaksperioden har blitt godkjent for registrering");

    private String kode;
    private String beskrivelse;

    Behandlingsresultattyper(String kode, String beskrivelse) {
        this.kode = kode;
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return kode;
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }

    @Converter
    public static class DbKonverterer extends InterntKodeverkTabell.DbKonverterer<Behandlingsresultattyper> {
        @Override
        protected Behandlingsresultattyper[] getLovligeVerdier() {
            return Behandlingsresultattyper.values();
        }
    }

}
