package no.nav.melosys.domain.kodeverk.begrunnelser;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Normaltdrivervirksomhet implements Kodeverk {

    IKKE_FORUTGAAENDE_DRIFT("Ikke tilstrekkelig forutgående drift"),
	HAR_IKKE_NØDVENDIG_INFRASTRUKTUR("Ikke nødvendig utstyr eller fasiliteter"),
	OPPRETTHOLDER_IKKE_LISENSER_AUTORISASJON("Opprettholder ikke nødvendige lisenser eller autorisasjoner");

    private final String beskrivelse;

    Normaltdrivervirksomhet(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
