package no.nav.melosys.domain.kodeverk.begrunnelser;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Forutgaendemedlemskap implements Kodeverk {

    IKKE_LOENNET_UTSEND_AG("Mottok IKKE lønn fra utsendende arbeidsgiver opptjent i Norge forutgående måned."),
	IKKE_LOENNET_NORGE("Mottok IKKE lønn fra annen arbeidsgiver opptjent i Norge forutgående måned."),
	MOTTAT_LOENN_UTL("Mottok lønn opptjent i annet land forutgående måned."),
	IKKE_FOLKEREGISTRERT_NORGE("Har ikke TPS-adresse i Norge."),
	IKKE_ANSATT_UTSEND_AG("Er IKKE registrert i Aa-registeret hos utsendende arbeidsgiver.");

    private final String beskrivelse;

    Forutgaendemedlemskap(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
