package no.nav.melosys.domain.kodeverk.begrunnelser;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Endretperiode implements Kodeverk {

    RETURNERT_NORGE("Arbeidstakeren har returnert til Norge"),
	ARBEIDSFORHOLD_AVSLUTTET("Arbeidsforholdet med utsendende arbeidsgiver er avsluttet"),
	ENDRINGER_ARBEIDSSITUASJON("Endringer i arbeidssituasjonen");

    private final String beskrivelse;

    Endretperiode(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
