package no.nav.melosys.domain.kodeverk;

public enum Aktoersroller implements Kodeverk {

    BRUKER("Bruker"),
	ARBEIDSGIVER("Arbeidsgiver"),
	REPRESENTANT("Fullmektig"),
	MYNDIGHET("Trygdemyndighet");

    private final String beskrivelse;

    Aktoersroller(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
