package no.nav.melosys.domain.kodeverk.behandlinger;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Behandlingstyper implements Kodeverk {

    SOEKNAD("Søknad"),
	SOEKNAD_IKKE_YRKESAKTIV("Søknad ikke yrkesaktiv"),
	SOEKNAD_ARBEID_FLERE_LAND("Søknad arbeid i flere land"),
	SOEKNAD_ARBEID_NORGE_BOSATT_ANNET_LAND("Søknad arbeid i Norge - bosatt i et annet land"),
	KLAGE("Klage"),
	ANKE("Anke"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_UTSTASJONERING("Registrering av unntak fra norsk trygd – utstasjonerte (A009)"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_ØVRIGE("Registrering av unntak fra norsk trygd – øvrige (A010)"),
	BESLUTNING_LOVVALG_NORGE("Behandling av at utenlandske myndigheter har utpekt Norge som lovvalgsland (A003)"),
	BESLUTNING_LOVVALG_ANNET_LAND("Utenlandsk myndighet har utpekt et annet land enn Norge (A003)"),
	NY_VURDERING("Behandle ny vurdering"),
	ENDRET_PERIODE("Behandle forkortet periode"),
	ANMODNING_OM_UNNTAK_HOVEDREGEL("Behandling av en mottatt anmodning om unntak hovedregel (A001)"),
	ØVRIGE_SED("Behandling av alle øvrige SED"),
	VURDER_TRYGDETID("Behandling av forespørsel om trygdetid");

    private final String beskrivelse;

    Behandlingstyper(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
