package no.nav.melosys.domain.kodeverk.begrunnelser;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Sokkel implements Kodeverk {

    FAST_INSTALLASJON("Fast installasjon"),
	IKKE_EGEN_FREMDRIFT("Ikke framdrift for egen maskin"),
	IKKE_ORDINAER_SKIPSFART("Skrogtypen kan ikke brukes i ordinær skipsfart"),
	BORESKIP("Boreskip - Sokkel");

    private final String beskrivelse;

    Sokkel(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
