package no.nav.melosys.domain.kodeverk.begrunnelser;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Inngangsvilkaar implements Kodeverk {

    MANGLER_STATSBORGERSKAP("Statborgerskap er ikke registrert for bruker i søknadsperioden."),
	TEKNISK_FEIL("Det har oppstått en teknisk feil ved automatisk vurdering av inngangsvilkår."),
	EOS_BORGER(null);

    private final String beskrivelse;

    Inngangsvilkaar(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
