package no.nav.melosys.domain.kodeverk.behandlinger;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Behandlingstema implements Kodeverk {

    UTSENDT_ARBEIDSTAKER("Utsendt arbeidstaker"),
	UTSENDT_SELVSTENDIG("Utsendt selvstendig næringsdrivende"),
	ARBEID_ETT_LAND_ØVRIG("Øvrig arbeid og næring"),
	IKKE_YRKESAKTIV("Ikke yrkesaktiv"),
	ARBEID_FLERE_LAND("Arbeid i flere land"),
	ARBEID_NORGE_BOSATT_ANNET_LAND("Arbeid i Norge - bosatt i et annet land"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_UTSTASJONERING("Registrering av unntak fra norsk trygd – utstasjonerte (A009)"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_ØVRIGE("Registrering av unntak fra norsk trygd – øvrige (A010)"),
	BESLUTNING_LOVVALG_NORGE("Norge er utpekt (A003)"),
	BESLUTNING_LOVVALG_ANNET_LAND("Utenlandsk myndighet har utpekt et annet land enn Norge (A003)"),
	ANMODNING_OM_UNNTAK_HOVEDREGEL("Behandling av en mottatt anmodning om unntak hovedregel (A001)"),
	ØVRIGE_SED("Behandling av alle øvrige SED"),
	TRYGDETID("Forespørsel om trygdetid");

    private final String beskrivelse;

    Behandlingstema(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
