package no.nav.melosys.domain.kodeverk.begrunnelser;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Inngangsvilkaar implements Kodeverk {

    MANGLER_STATSBORGERSKAP("Finner ikke statsborgerskap i NAVs registre."),
	TEKNISK_FEIL("Det oppsto en teknisk feil ved automatisk vurdering av inngangsvilkår.");

    private final String beskrivelse;

    Inngangsvilkaar(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
