package no.nav.melosys.domain.kodeverk.begrunnelser;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Kontroll_begrunnelser implements Kodeverk {

    TREDJELANDSBORGER_IKKE_AVTALELAND("Personen er ikke EØS-borger"),
	OVERLAPPENDE_MEDL_PERIODER("Det finnes overlappende periode i MEDL"),
	MOTTAR_YTELSER("Personen mottar ytelser"),
	PERIODEN_OVER_24_MD("Periodelengde er mer enn 24 måneder"),
	PERIODEN_OVER_5_AR("Periodelengde er mer enn 5 år"),
	FEIL_I_PERIODEN("Startdato er før sluttdato"),
	PERIODE_FOR_GAMMEL("Periode mer enn 5 år tilbake i tid"),
	PERIODE_LANGT_FREM_I_TID("Periode mer enn 1 år frem i tid"),
	BOSATT_I_NORGE("Personen har en folkeregistrert bostedsadresse i Norge"),
	INGEN_SLUTTDATO("Sluttdato mangler"),
	PERSON_DOD("Personen er død"),
	LOVVALGSLAND_NORGE("Norge er oppgitt som lovvalgsland"),
	ARBEIDSSTED_UTENFOR_EOS("Arbeidsstedet er utenfor EU/EØS"),
	MANGLENDE_BOSTEDSADRESSE("Bostedsadresse trengs for å kunne utstede A1."),
	MANGLENDE_OPPL_ARBEIDSSTED("Navn og land for arbeidssted trengs for utfylling av SED."),
	MANGLENDE_OPPL_ANDRE_ARBEIDSFORHOLD_NO("Navn og land for andre arbeidsforhold i Norge trengs for utfylling av SED."),
	MANGLENDE_OPPL_ANDRE_ARBEIDSFORHOLD_UTL("Navn og land for andre arbeidsforhold i utlandet trengs for utfylling av SED."),
	ANNET("Fritekstfelt");

    private final String beskrivelse;

    Kontroll_begrunnelser(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
