package no.nav.melosys.domain.kodeverk.behandlinger;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Behandlingstema implements Kodeverk {

    UTSENDT_ARBEIDSTAKER("MED: Utsendt arbeidstaker / skip / direkte til artikkel 16"),
	UTSENDT_SELVSTENDIG("MED: Utsendt selvstendig næringsdrivende / skip / direkte til artikkel 16"),
	ARBEID_ETT_LAND_ØVRIG("MED: Arbeid eller selvstendig virksomhet i ett land"),
	IKKE_YRKESAKTIV("MED: Ikke yrkesaktiv"),
	ARBEID_FLERE_LAND("MED: Arbeid og/eller selvstendig virksomhet i flere land"),
	ARBEID_NORGE_BOSATT_ANNET_LAND("MED: Arbeid eller selvstendig virksomhet i Norge - bosatt i et annet land"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_UTSTASJONERING("UFM: Melding om utstasjonering – A009"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_ØVRIGE("UFM: Melding om lovvalg – A010"),
	BESLUTNING_LOVVALG_NORGE("MED: Beslutning om norsk lovvalg – A003"),
	BESLUTNING_LOVVALG_ANNET_LAND("UFM: Beslutning om lovvalg i et annet land – A003"),
	ANMODNING_OM_UNNTAK_HOVEDREGEL("UFM: Anmodning om unntak – A001"),
	ØVRIGE_SED_MED("MED: Henvendelse eller forespørsel"),
	ØVRIGE_SED_UFM("UFM: Henvendelse eller forespørsel"),
	TRYGDETID("MED: Forespørsel om trygdetid");

    private final String beskrivelse;

    Behandlingstema(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
