package no.nav.melosys.domain.kodeverk.behandlinger;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Behandlingstyper implements Kodeverk {

    SOEKNAD("Søknad"),
	SED("SED"),
	NY_VURDERING("Ny vurdering"),
	KLAGE("Klage"),
	ANKE("Anke"),
	ENDRET_PERIODE("Behandle forkortet periode");

    private final String beskrivelse;

    Behandlingstyper(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
