package no.nav.melosys.domain.kodeverk;

public enum Saksstatuser implements Kodeverk {

    OPPRETTET("Saken er opprettet"),
	LOVVALG_AVKLART("Lovvalget er avklart"),
	VIDERESENDT("Saken er videresendt"),
	HENLAGT("Saken er henlagt"),
	HENLAGT_BORTFALT("Saken er henlagt som bortfalt i Melosys."),
	AVSLUTTET("Saken er avsluttet");

    private final String beskrivelse;

    Saksstatuser(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
