package no.nav.melosys.domain.kodeverk.behandlinger;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Behandlingstyper implements Kodeverk {

    SOEKNAD("Søknad"),
	SOEKNAD_IKKE_YRKESAKTIV("Søknad ikke yrkesaktiv"),
	KLAGE("Klage"),
	ANKE("Anke"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_UTSTASJONERING("Registrering av unntak fra norsk trygd – utstasjonerte (A009)"),
	REGISTRERING_UNNTAK_NORSK_TRYGD_ØVRIGE("Registrering av unntak fra norsk trygd – øvrige (A010)"),
	UTL_MYND_UTPEKT_NORGE("Norge er utpekt (A003)"),
	UTL_MYND_UTPEKT_SEG_SELV("Utl. myndh. har utpekt seg selv (A003)"),
	NY_VURDERING("Behandle ny vurdering"),
	ENDRET_PERIODE("Behandle forkortet periode"),
	ANMODNING_OM_UNNTAK_HOVEDREGEL("Behandling av en mottatt anmodning om unntak hovedregel (A001)"),
	ØVRIGE_SED("Behandling av alle øvrige SED"),
	VURDER_TRYGDETID("Behandling av forespørsel om trygdetid");

    private final String beskrivelse;

    Behandlingstyper(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
