package no.nav.melosys.domain.kodeverk.behandlinger;

import no.nav.melosys.domain.kodeverk.Kodeverk;

public enum Behandlingsstatus implements Kodeverk {

    OPPRETTET("Behandlingen er opprettet"),
	UNDER_BEHANDLING("Behandlingen pågår"),
	AVSLUTTET("Behandlingen er avsluttet"),
	AVVENT_DOK_UTL("Avventer svar fra utenlandsk trygdemyndighet"),
	AVVENT_DOK_PART("Avventer svar fra part i saken"),
	ANMODNING_UNNTAK_SENDT("Anmodning om unntak er sendt"),
	VURDER_DOKUMENT("Vurder dokument"),
	TIDSFRIST_UTLOEPT("Tidsfristen er utløpt på etterspurte opplysninger"),
	FORELOEPIG_LOVVALG("Avventer svar på foreløpig lovvalg"),
	IVERKSETTER_VEDTAK("Vedtak iverksettes"),
	SVAR_ANMODNING_MOTTATT("Mottatt svar på anmodning unntak"),
	UTPEKING_SENDT("Utpeking av et annet land er sendt"),
	SVAR_UTPEKING_MOTTATT("Mottatt svar på utpeking av et annet land");

    private final String beskrivelse;

    Behandlingsstatus(String beskrivelse) {
        this.beskrivelse = beskrivelse;
    }

    @Override
    public String getKode() {
        return name();
    }

    @Override
    public String getBeskrivelse() {
        return beskrivelse;
    }
}
