/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.extensions;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2Exception;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\u0014\u0010\b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\n\u0010\n\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a\f\u0010\u000f\u001a\u00020\u0002*\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"isAuthorizationEndpointUrl", "", "Lokhttp3/HttpUrl;", "isJwksUrl", "isTokenEndpointUrl", "isWellKnownUrl", "issuerId", "", "resolvePath", "path", "toAuthorizationEndpointUrl", "toIssuerUrl", "toJwksUrl", "toTokenEndpointUrl", "toWellKnownUrl", "withoutQuery", "mock-oauth2-server"})
public final class HttpUrlExtensionsKt {
    public static final boolean isWellKnownUrl(@NotNull HttpUrl $this$isWellKnownUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isWellKnownUrl, (String)"$this$isWellKnownUrl");
        return Intrinsics.areEqual((Object)$this$isWellKnownUrl, (Object)HttpUrlExtensionsKt.toWellKnownUrl($this$isWellKnownUrl));
    }

    public static final boolean isAuthorizationEndpointUrl(@NotNull HttpUrl $this$isAuthorizationEndpointUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAuthorizationEndpointUrl, (String)"$this$isAuthorizationEndpointUrl");
        return Intrinsics.areEqual((Object)HttpUrlExtensionsKt.withoutQuery($this$isAuthorizationEndpointUrl), (Object)HttpUrlExtensionsKt.toAuthorizationEndpointUrl($this$isAuthorizationEndpointUrl));
    }

    public static final boolean isTokenEndpointUrl(@NotNull HttpUrl $this$isTokenEndpointUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isTokenEndpointUrl, (String)"$this$isTokenEndpointUrl");
        return Intrinsics.areEqual((Object)$this$isTokenEndpointUrl, (Object)HttpUrlExtensionsKt.toTokenEndpointUrl($this$isTokenEndpointUrl));
    }

    public static final boolean isJwksUrl(@NotNull HttpUrl $this$isJwksUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isJwksUrl, (String)"$this$isJwksUrl");
        return Intrinsics.areEqual((Object)$this$isJwksUrl, (Object)HttpUrlExtensionsKt.toJwksUrl($this$isJwksUrl));
    }

    @NotNull
    public static final HttpUrl toWellKnownUrl(@NotNull HttpUrl $this$toWellKnownUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toWellKnownUrl, (String)"$this$toWellKnownUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toWellKnownUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toWellKnownUrl) + "/.well-known/openid-configuration");
    }

    @NotNull
    public static final HttpUrl toAuthorizationEndpointUrl(@NotNull HttpUrl $this$toAuthorizationEndpointUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toAuthorizationEndpointUrl, (String)"$this$toAuthorizationEndpointUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toAuthorizationEndpointUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toAuthorizationEndpointUrl) + "/authorize");
    }

    @NotNull
    public static final HttpUrl toTokenEndpointUrl(@NotNull HttpUrl $this$toTokenEndpointUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toTokenEndpointUrl, (String)"$this$toTokenEndpointUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toTokenEndpointUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toTokenEndpointUrl) + "/token");
    }

    @NotNull
    public static final HttpUrl toJwksUrl(@NotNull HttpUrl $this$toJwksUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toJwksUrl, (String)"$this$toJwksUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toJwksUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toJwksUrl) + "/jwks");
    }

    @NotNull
    public static final HttpUrl toIssuerUrl(@NotNull HttpUrl $this$toIssuerUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toIssuerUrl, (String)"$this$toIssuerUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toIssuerUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toIssuerUrl));
    }

    @NotNull
    public static final String issuerId(@NotNull HttpUrl $this$issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$issuerId, (String)"$this$issuerId");
        String string = (String)CollectionsKt.getOrNull((List)$this$issuerId.pathSegments(), (int)0);
        if (string == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "issuerId must be first segment in url path");
        }
        return string;
    }

    private static final HttpUrl withoutQuery(@NotNull HttpUrl $this$withoutQuery) {
        return $this$withoutQuery.newBuilder().query(null).build();
    }

    private static final HttpUrl resolvePath(@NotNull HttpUrl $this$resolvePath, String path) {
        HttpUrl httpUrl = new HttpUrl.Builder().scheme($this$resolvePath.scheme()).host($this$resolvePath.host()).port($this$resolvePath.port()).build().resolve(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        if (httpUrl == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "cannot resolve path " + path);
        }
        return httpUrl;
    }
}

