/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.extensions;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0003\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0003\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0003\u00a8\u0006\n"}, d2={"fromFormParameters", "Lcom/nimbusds/oauth2/sdk/http/HTTPRequest;", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "asAuthenticationRequest", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "asTokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "issuerId", "", "mock-oauth2-server"})
public final class RecordedRequestExtensionsKt {
    @NotNull
    public static final String issuerId(@NotNull RecordedRequest $this$issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$issuerId, (String)"$this$issuerId");
        Object object = $this$issuerId.getRequestUrl();
        if (object == null || (object = object.pathSegments()) == null || (object = (String)CollectionsKt.first((List)object)) == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "issuerid must be first segment in url path");
        }
        return object;
    }

    @NotNull
    public static final TokenRequest asTokenRequest(@NotNull RecordedRequest $this$asTokenRequest) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asTokenRequest, (String)"$this$asTokenRequest");
        TokenRequest tokenRequest = TokenRequest.parse((HTTPRequest)RecordedRequestExtensionsKt.fromFormParameters($this$asTokenRequest));
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenRequest, (String)"TokenRequest.parse(fromFormParameters(this))");
        return tokenRequest;
    }

    @NotNull
    public static final AuthenticationRequest asAuthenticationRequest(@NotNull RecordedRequest $this$asAuthenticationRequest) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asAuthenticationRequest, (String)"$this$asAuthenticationRequest");
        HttpUrl httpUrl = $this$asAuthenticationRequest.getRequestUrl();
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        AuthenticationRequest authenticationRequest = AuthenticationRequest.parse((URI)httpUrl.uri());
        Intrinsics.checkExpressionValueIsNotNull((Object)authenticationRequest, (String)"AuthenticationRequest.pa\u2026his.requestUrl!!.toUri())");
        return authenticationRequest;
    }

    private static final HTTPRequest fromFormParameters(RecordedRequest request) {
        String string = request.getMethod();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        HTTPRequest.Method method = HTTPRequest.Method.valueOf((String)string);
        HttpUrl httpUrl = request.getRequestUrl();
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        HTTPRequest httpRequest = new HTTPRequest(method, httpUrl.url());
        Iterable $this$forEach$iv = (Iterable)request.getHeaders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            httpRequest.setHeader((String)it.getFirst(), new String[]{(String)it.getSecond()});
        }
        httpRequest.setQuery(request.getBody().readUtf8());
        return httpRequest;
    }
}

