/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import net.minidev.json.JSONObject;
import no.nav.security.mock.callback.DefaultTokenCallback;
import no.nav.security.mock.callback.TokenCallback;
import no.nav.security.mock.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.extensions.MockResponseExtensionsKt;
import no.nav.security.mock.extensions.NimbusExtensionsKt;
import no.nav.security.mock.extensions.RecordedRequestExtensionsKt;
import no.nav.security.mock.oauth2.OAuth2DispatcherKt;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2TokenProvider;
import no.nav.security.mock.oauth2.WellKnown;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler;
import no.nav.security.mock.oauth2.grant.ClientCredentialsGrantHandler;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.JwtBearerGrantHandler;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lno/nav/security/mock/oauth2/OAuth2Dispatcher;", "Lokhttp3/mockwebserver/Dispatcher;", "tokenProvider", "Lno/nav/security/mock/oauth2/OAuth2TokenProvider;", "tokenCallbacks", "", "Lno/nav/security/mock/callback/TokenCallback;", "(Lno/nav/security/mock/oauth2/OAuth2TokenProvider;Ljava/util/Set;)V", "grantHandlers", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenCallbackQueue", "Ljava/util/concurrent/BlockingQueue;", "dispatch", "Lokhttp3/mockwebserver/MockResponse;", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "enqueueJwtCallback", "", "tokenCallback", "grantHandler", "grantType", "handleException", "error", "", "handleRequest", "issuerUrl", "Lokhttp3/HttpUrl;", "takeJwtCallbackOrCreateDefault", "issuerId", "", "wellKnown", "Lno/nav/security/mock/oauth2/WellKnown;", "mock-oauth2-server"})
public final class OAuth2Dispatcher
extends Dispatcher {
    private final BlockingQueue<TokenCallback> tokenCallbackQueue;
    private final Map<GrantType, GrantHandler> grantHandlers;
    private final OAuth2TokenProvider tokenProvider;
    private final Set<TokenCallback> tokenCallbacks;

    private final TokenCallback takeJwtCallbackOrCreateDefault(String issuerId) {
        TokenCallback tokenCallback;
        Object v2;
        block3: {
            TokenCallback tokenCallback2 = (TokenCallback)this.tokenCallbackQueue.peek();
            if (Intrinsics.areEqual((Object)(tokenCallback2 != null ? tokenCallback2.issuerId() : null), (Object)issuerId)) {
                TokenCallback tokenCallback3 = this.tokenCallbackQueue.take();
                Intrinsics.checkExpressionValueIsNotNull((Object)tokenCallback3, (String)"tokenCallbackQueue.take()");
                return tokenCallback3;
            }
            Iterable $this$firstOrNull$iv = this.tokenCallbacks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TokenCallback it = (TokenCallback)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.issuerId(), (Object)issuerId)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((tokenCallback = (TokenCallback)v2) == null) {
            tokenCallback = new DefaultTokenCallback(issuerId, null, null, null, 0L, 30, null);
        }
        return tokenCallback;
    }

    public final boolean enqueueJwtCallback(@NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        return this.tokenCallbackQueue.add(tokenCallback);
    }

    @NotNull
    public MockResponse dispatch(@NotNull RecordedRequest request) {
        MockResponse mockResponse;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        OAuth2Dispatcher oAuth2Dispatcher = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            OAuth2Dispatcher $this$runCatching = oAuth2Dispatcher;
            boolean bl2 = false;
            $this$runCatching = $this$runCatching.handleRequest(request);
            bl2 = false;
            object = Result.constructor-impl((Object)((Object)$this$runCatching));
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        oAuth2Dispatcher = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)oAuth2Dispatcher));
        if (throwable == null) {
            MockResponse result = (MockResponse)oAuth2Dispatcher;
            boolean bl5 = false;
            mockResponse = result;
        } else {
            Throwable error = throwable;
            boolean bl6 = false;
            mockResponse = this.handleException(error);
        }
        return mockResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MockResponse handleRequest(RecordedRequest request) {
        MockResponse mockResponse;
        OAuth2DispatcherKt.access$getLog$p().debug("received request on url=" + request.getRequestUrl() + " with headers=" + request.getHeaders());
        String issuerId = RecordedRequestExtensionsKt.issuerId(request);
        HttpUrl httpUrl = request.getRequestUrl();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (httpUrl == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        HttpUrl url = httpUrl;
        if (HttpUrlExtensionsKt.isWellKnownUrl(url)) {
            OAuth2DispatcherKt.access$getLog$p().debug("returning well-known json data for url=" + url);
            mockResponse = MockResponseExtensionsKt.json(new MockResponse(), this.wellKnown(request));
            return mockResponse;
        } else if (HttpUrlExtensionsKt.isAuthorizationEndpointUrl(url)) {
            OAuth2DispatcherKt.access$getLog$p().debug("redirecting to callback with auth code");
            AuthenticationRequest authRequest = RecordedRequestExtensionsKt.asAuthenticationRequest(request);
            if (!authRequest.getResponseType().impliesCodeFlow()) throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_GRANT, "hybrid og implicit flow not supported (yet).");
            GrantHandler grantHandler = this.grantHandlers.get(GrantType.AUTHORIZATION_CODE);
            if (grantHandler == null) {
                throw new TypeCastException("null cannot be cast to non-null type no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler");
            }
            mockResponse = MockResponseExtensionsKt.authenticationSuccess(new MockResponse(), ((AuthorizationCodeHandler)grantHandler).authorizationCodeResponse(RecordedRequestExtensionsKt.asAuthenticationRequest(request)));
            return mockResponse;
        } else if (HttpUrlExtensionsKt.isTokenEndpointUrl(url)) {
            OAuth2DispatcherKt.access$getLog$p().debug("handle token request " + request);
            TokenCallback tokenCallback = this.takeJwtCallbackOrCreateDefault(issuerId);
            TokenRequest tokenRequest = RecordedRequestExtensionsKt.asTokenRequest(request);
            bl3 = false;
            boolean bl5 = false;
            TokenRequest it = tokenRequest;
            boolean bl6 = false;
            KLogger kLogger = OAuth2DispatcherKt.access$getLog$p();
            StringBuilder stringBuilder = new StringBuilder().append("query in tokenreq: ");
            HTTPRequest hTTPRequest = it.toHTTPRequest();
            Intrinsics.checkExpressionValueIsNotNull((Object)hTTPRequest, (String)"it.toHTTPRequest()");
            kLogger.debug(stringBuilder.append(hTTPRequest.getQuery()).toString());
            TokenRequest tokenRequest2 = tokenRequest;
            HttpUrl issuerUrl = this.issuerUrl(request);
            mockResponse = MockResponseExtensionsKt.json(new MockResponse(), this.grantHandler(NimbusExtensionsKt.grantType(tokenRequest2)).tokenResponse(tokenRequest2, issuerUrl, tokenCallback));
            return mockResponse;
        } else if (HttpUrlExtensionsKt.isJwksUrl(url)) {
            OAuth2DispatcherKt.access$getLog$p().debug("handle jwks request");
            MockResponse mockResponse2 = new MockResponse();
            JSONObject jSONObject = this.tokenProvider.publicJwkSet().toJSONObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"tokenProvider.publicJwkSet().toJSONObject()");
            mockResponse = MockResponseExtensionsKt.json(mockResponse2, jSONObject);
            return mockResponse;
        } else {
            String msg = "path '" + request.getRequestUrl() + "' not found";
            OAuth2DispatcherKt.access$getLog$p().error(msg);
            mockResponse = new MockResponse().setResponseCode(404).setBody(msg);
        }
        return mockResponse;
    }

    private final MockResponse handleException(Throwable error) {
        ErrorObject errorObject;
        Object object;
        OAuth2DispatcherKt.access$getLog$p().error("received exception when handling request.", error);
        Throwable throwable = error;
        if (throwable instanceof OAuth2Exception) {
            object = ((OAuth2Exception)error).getErrorObject();
        } else if (throwable instanceof ParseException) {
            object = ((ParseException)error).getErrorObject();
            if (object == null) {
                object = OAuth2Error.INVALID_REQUEST.appendDescription(". received exception message: " + error.getMessage());
            }
        } else {
            object = errorObject = throwable instanceof GeneralException ? ((GeneralException)error).getErrorObject() : null;
        }
        if (object == null) {
            ErrorObject errorObject2 = OAuth2Error.SERVER_ERROR.appendDescription(". received exception message: " + error.getMessage());
            errorObject = errorObject2;
            Intrinsics.checkExpressionValueIsNotNull((Object)errorObject2, (String)"OAuth2Error.SERVER_ERROR\u2026ssage: ${error.message}\")");
        }
        ErrorObject errorObject3 = errorObject;
        return MockResponseExtensionsKt.oauth2Error(new MockResponse(), errorObject3);
    }

    private final WellKnown wellKnown(RecordedRequest request) {
        HttpUrl httpUrl = request.getRequestUrl();
        HttpUrl httpUrl2 = request.getRequestUrl();
        HttpUrl httpUrl3 = request.getRequestUrl();
        HttpUrl httpUrl4 = request.getRequestUrl();
        return new WellKnown(String.valueOf(httpUrl != null ? HttpUrlExtensionsKt.toIssuerUrl(httpUrl) : null), String.valueOf(httpUrl2 != null ? HttpUrlExtensionsKt.toAuthorizationEndpointUrl(httpUrl2) : null), String.valueOf(httpUrl3 != null ? HttpUrlExtensionsKt.toTokenEndpointUrl(httpUrl3) : null), String.valueOf(httpUrl4 != null ? HttpUrlExtensionsKt.toJwksUrl(httpUrl4) : null), null, null, null, 112, null);
    }

    private final HttpUrl issuerUrl(RecordedRequest request) {
        HttpUrl httpUrl = request.getRequestUrl();
        if (httpUrl == null || (httpUrl = HttpUrlExtensionsKt.toIssuerUrl(httpUrl)) == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "issuerid must be first segment in url path");
        }
        return httpUrl;
    }

    private final GrantHandler grantHandler(GrantType grantType) {
        GrantHandler grantHandler = this.grantHandlers.get(grantType);
        if (grantHandler == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_GRANT, "grant_type " + grantType + " not supported.");
        }
        return grantHandler;
    }

    public OAuth2Dispatcher(@NotNull OAuth2TokenProvider tokenProvider, @NotNull Set<? extends TokenCallback> tokenCallbacks) {
        Intrinsics.checkParameterIsNotNull((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkParameterIsNotNull(tokenCallbacks, (String)"tokenCallbacks");
        this.tokenProvider = tokenProvider;
        this.tokenCallbacks = tokenCallbacks;
        this.tokenCallbackQueue = new LinkedBlockingQueue();
        this.grantHandlers = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)GrantType.AUTHORIZATION_CODE, (Object)new AuthorizationCodeHandler(this.tokenProvider)), TuplesKt.to((Object)GrantType.CLIENT_CREDENTIALS, (Object)new ClientCredentialsGrantHandler(this.tokenProvider)), TuplesKt.to((Object)GrantType.JWT_BEARER, (Object)new JwtBearerGrantHandler(this.tokenProvider))});
    }

    public /* synthetic */ OAuth2Dispatcher(OAuth2TokenProvider oAuth2TokenProvider, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            oAuth2TokenProvider = new OAuth2TokenProvider();
        }
        if ((n & 2) != 0) {
            set = SetsKt.setOf((Object)new DefaultTokenCallback(null, null, "default", null, 0L, 27, null));
        }
        this(oAuth2TokenProvider, set);
    }

    public OAuth2Dispatcher() {
        this(null, null, 3, null);
    }
}

