/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.callback.TokenCallback;
import no.nav.security.mock.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.OAuth2TokenProvider;
import no.nav.security.mock.oauth2.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeGrantHandlerKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/OAuth2TokenProvider;", "(Lno/nav/security/mock/oauth2/OAuth2TokenProvider;)V", "codeToAuthRequestCache", "", "Lcom/nimbusds/oauth2/sdk/AuthorizationCode;", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "authorizationCodeResponse", "Lcom/nimbusds/openid/connect/sdk/AuthenticationSuccessResponse;", "authenticationRequest", "getAuthenticationRequest", "code", "tokenResponse", "Lno/nav/security/mock/oauth2/OAuth2TokenResponse;", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "tokenCallback", "Lno/nav/security/mock/callback/TokenCallback;", "mock-oauth2-server"})
public final class AuthorizationCodeHandler
implements GrantHandler {
    private final Map<AuthorizationCode, AuthenticationRequest> codeToAuthRequestCache;
    private final OAuth2TokenProvider tokenProvider;

    @NotNull
    public final AuthenticationSuccessResponse authorizationCodeResponse(@NotNull AuthenticationRequest authenticationRequest) {
        Intrinsics.checkParameterIsNotNull((Object)authenticationRequest, (String)"authenticationRequest");
        AuthorizationCode code = new AuthorizationCode();
        AuthorizationCodeGrantHandlerKt.access$getLog$p().debug("issuing authorization code " + code);
        this.codeToAuthRequestCache.put(code, authenticationRequest);
        return new AuthenticationSuccessResponse(authenticationRequest.getRedirectionURI(), code, null, null, authenticationRequest.getState(), null, authenticationRequest.getResponseMode());
    }

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkParameterIsNotNull((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        AuthenticationRequest authenticationRequest = this.getAuthenticationRequest(NimbusExtensionsKt.authorizationCode(tokenRequest));
        Scope scope = tokenRequest.getScope();
        String scope2 = scope != null ? scope.toString() : null;
        AuthenticationRequest authenticationRequest2 = authenticationRequest;
        String nonce = authenticationRequest2 != null && (authenticationRequest2 = authenticationRequest2.getNonce()) != null ? authenticationRequest2.getValue() : null;
        SignedJWT idToken = this.tokenProvider.idToken(tokenRequest, issuerUrl, nonce, tokenCallback);
        SignedJWT accessToken = this.tokenProvider.accessToken(tokenRequest, issuerUrl, nonce, tokenCallback);
        return new OAuth2TokenResponse("Bearer", idToken.serialize(), accessToken.serialize(), UUID.randomUUID().toString(), NimbusExtensionsKt.expiresIn(idToken), scope2);
    }

    private final AuthenticationRequest getAuthenticationRequest(AuthorizationCode code) {
        return this.codeToAuthRequestCache.get(code);
    }

    public AuthorizationCodeHandler(@NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkParameterIsNotNull((Object)tokenProvider, (String)"tokenProvider");
        this.tokenProvider = tokenProvider;
        this.codeToAuthRequestCache = new HashMap();
    }
}

