/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.MockOAuth2ServerKt;
import no.nav.security.mock.callback.DefaultTokenCallback;
import no.nav.security.mock.callback.TokenCallback;
import no.nav.security.mock.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.OAuth2Dispatcher;
import no.nav.security.mock.oauth2.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001e2\b\b\u0002\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lno/nav/security/mock/MockOAuth2Server;", "", "tokenCallbacks", "", "Lno/nav/security/mock/callback/TokenCallback;", "(Ljava/util/Set;)V", "dispatcher", "Lokhttp3/mockwebserver/Dispatcher;", "getDispatcher", "()Lokhttp3/mockwebserver/Dispatcher;", "setDispatcher", "(Lokhttp3/mockwebserver/Dispatcher;)V", "mockWebServer", "Lokhttp3/mockwebserver/MockWebServer;", "tokenProvider", "Lno/nav/security/mock/oauth2/OAuth2TokenProvider;", "authorizationEndpointUrl", "Lokhttp3/HttpUrl;", "issuerId", "", "baseUrl", "enqueueCallback", "", "tokenCallback", "issueToken", "Lcom/nimbusds/jwt/SignedJWT;", "clientId", "issuerUrl", "jwksUrl", "shutdown", "", "start", "port", "", "takeRequest", "Lokhttp3/mockwebserver/RecordedRequest;", "tokenEndpointUrl", "wellKnownUrl", "mock-oauth2-server"})
public final class MockOAuth2Server {
    private final MockWebServer mockWebServer;
    private final OAuth2TokenProvider tokenProvider;
    @NotNull
    private Dispatcher dispatcher;

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"<set-?>");
        this.dispatcher = dispatcher;
    }

    public final void start() {
        MockWebServer.start$default((MockWebServer)this.mockWebServer, (int)0, (int)1, null);
        this.mockWebServer.setDispatcher(this.dispatcher);
    }

    public final void start(int port) {
        InetAddress address = new InetSocketAddress(0).getAddress();
        MockOAuth2ServerKt.access$getLog$p().info("attempting to start server on port " + port + " and InetAddress=" + address);
        InetAddress inetAddress = address;
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"address");
        this.mockWebServer.start(inetAddress, port);
        this.mockWebServer.setDispatcher(this.dispatcher);
    }

    public static /* synthetic */ void start$default(MockOAuth2Server mockOAuth2Server, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockOAuth2Server.start(n);
    }

    public final void shutdown() throws IOException {
        this.mockWebServer.shutdown();
    }

    public final boolean enqueueCallback(@NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher == null) {
            throw new TypeCastException("null cannot be cast to non-null type no.nav.security.mock.oauth2.OAuth2Dispatcher");
        }
        return ((OAuth2Dispatcher)dispatcher).enqueueJwtCallback(tokenCallback);
    }

    @NotNull
    public final RecordedRequest takeRequest() {
        return this.mockWebServer.takeRequest();
    }

    @NotNull
    public final HttpUrl wellKnownUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toWellKnownUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl tokenEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toTokenEndpointUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl jwksUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toJwksUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl issuerUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return this.mockWebServer.url(issuerId);
    }

    @NotNull
    public final HttpUrl authorizationEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl baseUrl() {
        return this.mockWebServer.url("");
    }

    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String clientId, @NotNull TokenCallback tokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)tokenCallback, (String)"tokenCallback");
        HttpUrl uri = this.tokenEndpointUrl(issuerId);
        HttpUrl issuerUrl = this.issuerUrl(issuerId);
        TokenRequest tokenRequest = new TokenRequest(uri.uri(), (ClientAuthentication)new ClientSecretBasic(new ClientID(clientId), new Secret("secret")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("123"), URI.create("http://localhost")));
        return this.tokenProvider.accessToken(tokenRequest, issuerUrl, null, tokenCallback);
    }

    public MockOAuth2Server(@NotNull Set<? extends TokenCallback> tokenCallbacks) {
        Intrinsics.checkParameterIsNotNull(tokenCallbacks, (String)"tokenCallbacks");
        this.mockWebServer = new MockWebServer();
        this.tokenProvider = new OAuth2TokenProvider();
        this.dispatcher = new OAuth2Dispatcher(this.tokenProvider, tokenCallbacks);
    }

    public /* synthetic */ MockOAuth2Server(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.setOf((Object)new DefaultTokenCallback(null, null, null, null, 0L, 31, null));
        }
        this(set);
    }

    public MockOAuth2Server() {
        this(null, 1, null);
    }
}

