/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.net.URI;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0006\u0010\f\u001a\u00020\u0003\u001a\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "authenticationSuccess", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "authenticationSuccessResponse", "Lcom/nimbusds/openid/connect/sdk/AuthenticationSuccessResponse;", "html", "content", "", "json", "anyObject", "", "notFound", "oauth2Error", "error", "Lcom/nimbusds/oauth2/sdk/ErrorObject;", "mock-oauth2-server"})
public final class OAuth2HttpResponseKt {
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();

    @NotNull
    public static final OAuth2HttpResponse json(@NotNull Object anyObject) {
        Intrinsics.checkParameterIsNotNull((Object)anyObject, (String)"anyObject");
        Object object = anyObject;
        return new OAuth2HttpResponse(Headers.Companion.of(new String[]{"Content-Type", "application/json;charset=UTF-8"}), 200, object instanceof String ? (String)anyObject : objectMapper.enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(anyObject));
    }

    @NotNull
    public static final OAuth2HttpResponse html(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        return new OAuth2HttpResponse(Headers.Companion.of(new String[]{"Content-Type", "text/html;charset=UTF-8"}), 200, content);
    }

    @NotNull
    public static final OAuth2HttpResponse notFound() {
        return new OAuth2HttpResponse(null, 404, null, 5, null);
    }

    @NotNull
    public static final OAuth2HttpResponse authenticationSuccess(@NotNull AuthenticationSuccessResponse authenticationSuccessResponse) {
        Intrinsics.checkParameterIsNotNull((Object)authenticationSuccessResponse, (String)"authenticationSuccessResponse");
        HTTPResponse httpResponse = authenticationSuccessResponse.toHTTPResponse();
        String[] stringArray = new String[2];
        stringArray[0] = "Location";
        HTTPResponse hTTPResponse = httpResponse;
        Intrinsics.checkExpressionValueIsNotNull((Object)hTTPResponse, (String)"httpResponse");
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            Intrinsics.throwNpe();
        }
        String string = uRI.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"httpResponse.location!!.toString()");
        stringArray[1] = string;
        return new OAuth2HttpResponse(Headers.Companion.of(stringArray), 302, null, 4, null);
    }

    @NotNull
    public static final OAuth2HttpResponse oauth2Error(@NotNull ErrorObject error) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Object object = error.getHTTPStatusCode();
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)object).intValue();
        boolean bl3 = false;
        Object object2 = !(it == 302) ? object : null;
        int responseCode = object2 != null ? (Integer)object2 : 400;
        Headers headers = Headers.Companion.of(new String[]{"Content-Type", "application/json;charset=UTF-8"});
        String string2 = objectMapper.enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)error.toJSONObject());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"objectMapper\n           \u2026ing(error.toJSONObject())");
        object = string2;
        int n = responseCode;
        Headers headers2 = headers;
        bl = false;
        Object object3 = object;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object3).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string = string3;
        int n2 = n;
        Headers headers3 = headers2;
        return new OAuth2HttpResponse(headers3, n2, string4);
    }
}

