/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BE\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lno/nav/security/mock/oauth2/token/DefaultOAuth2TokenCallback;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "issuerId", "", "subject", "audience", "claims", "", "", "expiry", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;J)V", "addClaims", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "tokenExpiry", "mock-oauth2-server"})
public class DefaultOAuth2TokenCallback
implements OAuth2TokenCallback {
    private final String issuerId;
    private final String subject;
    private final String audience;
    private final Map<String, Object> claims;
    private final long expiry;

    @Override
    @NotNull
    public String issuerId() {
        return this.issuerId;
    }

    @Override
    @NotNull
    public String subject(@NotNull TokenRequest tokenRequest) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        GrantType grantType = GrantType.CLIENT_CREDENTIALS;
        if (Intrinsics.areEqual((Object)grantType, (Object)NimbusExtensionsKt.grantType(tokenRequest))) {
            ClientID clientID = tokenRequest.getClientID();
            Intrinsics.checkExpressionValueIsNotNull((Object)clientID, (String)"tokenRequest.clientID");
            String string2 = clientID.getValue();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tokenRequest.clientID.value");
        } else {
            string = this.subject;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String audience(@NotNull TokenRequest tokenRequest) {
        String string;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        OIDCScopeValue[] oIDCScopeValueArray = OIDCScopeValue.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)oIDCScopeValueArray, (String)"OIDCScopeValue.values()");
        OIDCScopeValue[] $this$map$iv = oIDCScopeValueArray;
        boolean $i$f$map = false;
        OIDCScopeValue[] oIDCScopeValueArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_13 = item$iv$iv = var8_8[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toString();
            collection.add(string2);
        }
        List oidcScopeList = (List)destination$iv$iv;
        String string3 = this.audience;
        if (string3 == null) {
            DefaultOAuth2TokenCallback defaultOAuth2TokenCallback = this;
            boolean bl = false;
            boolean bl2 = false;
            DefaultOAuth2TokenCallback it = defaultOAuth2TokenCallback;
            boolean bl3 = false;
            Object object = tokenRequest.getScope();
            if (object != null && (object = object.toStringList()) != null) {
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = (Iterable)object;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (oidcScopeList.contains(it2)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                string3 = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
            } else {
                string3 = string = null;
            }
        }
        if (string3 == null) {
            string = "default";
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, Object> addClaims(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkParameterIsNotNull((Object)tokenRequest, (String)"tokenRequest");
        Map map = MapsKt.toMutableMap(this.claims);
        boolean bl = false;
        boolean bl2 = false;
        Map $this$apply = map;
        boolean bl3 = false;
        $this$apply.putAll(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"azp", (Object)NimbusExtensionsKt.clientIdAsString(tokenRequest)), TuplesKt.to((Object)"tid", (Object)this.issuerId)}));
        return map;
    }

    @Override
    public long tokenExpiry() {
        return this.expiry;
    }

    public DefaultOAuth2TokenCallback(@NotNull String issuerId, @NotNull String subject, @Nullable String audience, @NotNull Map<String, ? extends Object> claims, long expiry) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull(claims, (String)"claims");
        this.issuerId = issuerId;
        this.subject = subject;
        this.audience = audience;
        this.claims = claims;
        this.expiry = expiry;
    }

    public /* synthetic */ DefaultOAuth2TokenCallback(String string, String string2, String string3, Map map, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "default";
        }
        if ((n & 2) != 0) {
            String string4 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"UUID.randomUUID().toString()");
            string2 = string4;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            l = 3600L;
        }
        this(string, string2, string3, map, l);
    }

    public DefaultOAuth2TokenCallback() {
        this(null, null, null, null, 0L, 31, null);
    }
}

