/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.MockOAuth2Dispatcher;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0017J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0012\u0010#\u001a\u00020\"2\b\b\u0002\u0010&\u001a\u00020'H\u0007J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0012J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lno/nav/security/mock/oauth2/MockOAuth2Server;", "", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "getConfig", "()Lno/nav/security/mock/oauth2/OAuth2Config;", "dispatcher", "Lokhttp3/mockwebserver/Dispatcher;", "getDispatcher", "()Lokhttp3/mockwebserver/Dispatcher;", "setDispatcher", "(Lokhttp3/mockwebserver/Dispatcher;)V", "mockWebServer", "Lokhttp3/mockwebserver/MockWebServer;", "authorizationEndpointUrl", "Lokhttp3/HttpUrl;", "issuerId", "", "baseUrl", "enqueueCallback", "", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueResponse", "response", "Lokhttp3/mockwebserver/MockResponse;", "issueToken", "Lcom/nimbusds/jwt/SignedJWT;", "clientId", "OAuth2TokenCallback", "issuerUrl", "jwksUrl", "shutdown", "", "start", "inetAddress", "Ljava/net/InetAddress;", "port", "", "takeRequest", "Lokhttp3/mockwebserver/RecordedRequest;", "tokenEndpointUrl", "url", "path", "wellKnownUrl", "mock-oauth2-server"})
public final class MockOAuth2Server {
    private final MockWebServer mockWebServer;
    @NotNull
    private Dispatcher dispatcher;
    @NotNull
    private final OAuth2Config config;

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"<set-?>");
        this.dispatcher = dispatcher;
    }

    @JvmOverloads
    public final void start(int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName("localhost");
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getByName(\"localhost\")");
        this.start(inetAddress, port);
    }

    public static /* synthetic */ void start$default(MockOAuth2Server mockOAuth2Server, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockOAuth2Server.start(n);
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockOAuth2Server.start$default(this, 0, 1, null);
    }

    public final void start(@NotNull InetAddress inetAddress, int port) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inetAddress, (String)"inetAddress");
        this.mockWebServer.start(inetAddress, port);
        this.mockWebServer.setDispatcher(this.dispatcher);
    }

    public final void shutdown() throws IOException {
        this.mockWebServer.shutdown();
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.mockWebServer.url(path);
    }

    public final boolean enqueueResponse(@NotNull MockResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher == null) {
            throw new TypeCastException("null cannot be cast to non-null type no.nav.security.mock.oauth2.MockOAuth2Dispatcher");
        }
        return ((MockOAuth2Dispatcher)dispatcher).enqueueResponse(response);
    }

    public final boolean enqueueCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkParameterIsNotNull((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher == null) {
            throw new TypeCastException("null cannot be cast to non-null type no.nav.security.mock.oauth2.MockOAuth2Dispatcher");
        }
        return ((MockOAuth2Dispatcher)dispatcher).enqueueTokenCallback(oAuth2TokenCallback);
    }

    @NotNull
    public final RecordedRequest takeRequest() {
        return this.mockWebServer.takeRequest();
    }

    @NotNull
    public final HttpUrl wellKnownUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toWellKnownUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl tokenEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toTokenEndpointUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl jwksUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toJwksUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl issuerUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return this.mockWebServer.url(issuerId);
    }

    @NotNull
    public final HttpUrl authorizationEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl baseUrl() {
        return this.mockWebServer.url("");
    }

    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String clientId, @NotNull OAuth2TokenCallback OAuth2TokenCallback2) {
        Intrinsics.checkParameterIsNotNull((Object)issuerId, (String)"issuerId");
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)OAuth2TokenCallback2, (String)"OAuth2TokenCallback");
        HttpUrl uri = this.tokenEndpointUrl(issuerId);
        HttpUrl issuerUrl = this.issuerUrl(issuerId);
        TokenRequest tokenRequest = new TokenRequest(uri.uri(), (ClientAuthentication)new ClientSecretBasic(new ClientID(clientId), new Secret("secret")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("123"), URI.create("http://localhost")));
        return this.config.getTokenProvider().accessToken(tokenRequest, issuerUrl, null, OAuth2TokenCallback2);
    }

    @NotNull
    public final OAuth2Config getConfig() {
        return this.config;
    }

    public MockOAuth2Server(@NotNull OAuth2Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.mockWebServer = new MockWebServer();
        this.dispatcher = new MockOAuth2Dispatcher(this.config);
    }

    public /* synthetic */ MockOAuth2Server(OAuth2Config oAuth2Config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            oAuth2Config = new OAuth2Config(false, null, null, 7, null);
        }
        this(oAuth2Config);
    }

    public MockOAuth2Server() {
        this(null, 1, null);
    }
}

