/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandlerKt;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.templates.TemplateMapper;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler;", "", "templateMapper", "Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "(Lno/nav/security/mock/oauth2/templates/TemplateMapper;)V", "encryptionKey", "Ljavax/crypto/SecretKey;", "getDecryptedSessionCookie", "", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "handleDebuggerCallback", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "handleDebuggerForm", "Companion", "mock-oauth2-server"})
public final class DebuggerRequestHandler {
    private final SecretKey encryptionKey;
    private final TemplateMapper templateMapper;
    @NotNull
    public static final String DEBUGGER_SESSION_COOKIE = "debugger-session";
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final OAuth2HttpResponse handleDebuggerForm(@NotNull OAuth2HttpRequest request) {
        OAuth2HttpResponse oAuth2HttpResponse;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String string = request.getMethod();
        switch (string.hashCode()) {
            case 2461856: {
                if (!string.equals("POST")) throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "Unsupported request method " + request.getMethod());
                break;
            }
            case 70454: {
                if (!string.equals("GET")) throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "Unsupported request method " + request.getMethod());
                DebuggerRequestHandlerKt.access$getLog$p().debug("handling GET request, return html form");
                oAuth2HttpResponse = OAuth2HttpResponseKt.html(this.templateMapper.debuggerFormHtml(DebuggerRequestHandlerKt.access$debuggerAuthorizationRequest(HttpUrlExtensionsKt.toAuthorizationEndpointUrl(request.getUrl()), HttpUrlExtensionsKt.toDebuggerCallbackUrl(request.getUrl()))));
                return oAuth2HttpResponse;
            }
        }
        DebuggerRequestHandlerKt.access$getLog$p().debug("handling POST request, return redirect");
        String authorizeUrl = request.getFormParameters().get("authorize_url");
        String string2 = authorizeUrl;
        HttpUrl httpUrl = string2 != null && (string2 = HttpUrl.Companion.get(string2)) != null && (string2 = string2.newBuilder()) != null && (string2 = string2.encodedQuery(request.getFormParameters().getParameterString())) != null && (string2 = string2.removeAllEncodedQueryParameters("authorize_url")) != null && (string2 = string2.removeAllEncodedQueryParameters("token_url")) != null && (string2 = string2.removeAllEncodedQueryParameters("client_secret")) != null ? string2.build() : null;
        DebuggerRequestHandlerKt.access$getLog$p().debug("attempting to redirect to " + httpUrl + ", setting received params in encrypted cookie");
        String string3 = OAuth2HttpResponseKt.getObjectMapper().writeValueAsString(request.getFormParameters().getMap());
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"objectMapper.writeValueA\u2026quest.formParameters.map)");
        String cookieValue = DebuggerRequestHandlerKt.access$encrypt(string3, this.encryptionKey);
        oAuth2HttpResponse = OAuth2HttpResponseKt.redirect(String.valueOf(httpUrl), Headers.Companion.of(new String[]{"Set-Cookie", "debugger-session=" + cookieValue + "; HttpOnly;"}));
        return oAuth2HttpResponse;
        throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "Unsupported request method " + request.getMethod());
    }

    @NotNull
    public final OAuth2HttpResponse handleDebuggerCallback(@NotNull OAuth2HttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        DebuggerRequestHandlerKt.access$getLog$p().debug("handling " + request.getMethod() + " request to debugger callback");
        String string = this.getDecryptedSessionCookie(request);
        if (string == null) {
            String string2 = "<p>Expired session, please try again using the debugger form - " + "<a href='" + HttpUrlExtensionsKt.toDebuggerUrl(request.getUrl()) + "'>" + HttpUrlExtensionsKt.toDebuggerUrl(request.getUrl()) + "</></p>";
            Headers headers = Headers.Companion.of(new String[]{"Content-Type", "text/html"});
            int n = 500;
            return new OAuth2HttpResponse(headers, n, string2);
        }
        String decryptedSessionCookie = string;
        ObjectMapper $this$readValue$iv = OAuth2HttpResponseKt.getObjectMapper();
        boolean $i$f$readValue = false;
        String string3 = decryptedSessionCookie;
        ObjectMapper objectMapper = $this$readValue$iv;
        boolean $i$f$jacksonTypeRef = false;
        TypeReference typeReference = (TypeReference)new TypeReference<Map<String, String>>(){};
        Map sessionParameters = (Map)objectMapper.readValue(string3, typeReference);
        String string4 = (String)sessionParameters.get("token_url");
        if (string4 == null || (string4 = HttpUrl.Companion.get(string4)) == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing token_url initial call");
        }
        String tokenUrl = string4;
        String string5 = request.getUrl().queryParameter("code");
        if (string5 == null) {
            string5 = request.getFormParameters().get("code");
        }
        if (string5 == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "no code parameter present");
        }
        String code = string5;
        String body = DebuggerRequestHandlerKt.access$toKeyValueString(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"scope", (Object)DebuggerRequestHandlerKt.access$urlEncodeParameter(sessionParameters, "scope")), TuplesKt.to((Object)"redirect_uri", (Object)DebuggerRequestHandlerKt.access$urlEncodeParameter(sessionParameters, "redirect_uri")), TuplesKt.to((Object)"client_id", (Object)DebuggerRequestHandlerKt.access$urlEncodeParameter(sessionParameters, "client_id")), TuplesKt.to((Object)"client_secret", (Object)DebuggerRequestHandlerKt.access$urlEncodeParameter(sessionParameters, "client_secret"))}), "&");
        ResponseBody responseBody = DebuggerRequestHandlerKt.access$getClient$p().newCall(new Request.Builder().url((HttpUrl)tokenUrl).post(RequestBody.Companion.create(body, MediaType.Companion.get("application/x-www-form-urlencoded"))).build()).execute().body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String tokenResponse = responseBody.string();
        String formattedTokenRequest = "POST " + tokenUrl.encodedPath() + " HTTP/1.1\n" + "Host: " + Util.toHostHeader((HttpUrl)tokenUrl, (boolean)true) + '\n' + "Content-Type: application/x-www-form-urlencoded\n" + '\n' + body;
        return OAuth2HttpResponseKt.html(this.templateMapper.debuggerCallbackHtml(formattedTokenRequest, tokenResponse));
    }

    private final String getDecryptedSessionCookie(OAuth2HttpRequest request) {
        String string;
        Object object;
        DebuggerRequestHandler debuggerRequestHandler = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = debuggerRequestHandler;
            boolean bl2 = false;
            String string2 = request.getCookies().get(DEBUGGER_SESSION_COOKIE);
            $this$runCatching = string2 != null ? DebuggerRequestHandlerKt.access$decrypt(string2, ((DebuggerRequestHandler)$this$runCatching).encryptionKey) : null;
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        debuggerRequestHandler = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)debuggerRequestHandler);
        if (throwable == null) {
            String result = (String)((Object)debuggerRequestHandler);
            boolean bl5 = false;
            string = result;
        } else {
            Throwable error = throwable;
            boolean bl6 = false;
            DebuggerRequestHandlerKt.access$getLog$p().error("received exception when decrypting cookie", error);
            string = null;
        }
        return string;
    }

    public DebuggerRequestHandler(@NotNull TemplateMapper templateMapper2) {
        Intrinsics.checkParameterIsNotNull((Object)templateMapper2, (String)"templateMapper");
        this.templateMapper = templateMapper2;
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        DebuggerRequestHandler debuggerRequestHandler = this;
        boolean bl = false;
        boolean bl2 = false;
        KeyGenerator $this$apply = keyGenerator;
        boolean bl3 = false;
        $this$apply.init(128);
        KeyGenerator keyGenerator2 = keyGenerator;
        SecretKey secretKey = keyGenerator2.generateKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"KeyGenerator.getInstance\u2026          }.generateKey()");
        debuggerRequestHandler.encryptionKey = secretKey;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler$Companion;", "", "()V", "DEBUGGER_SESSION_COOKIE", "", "mock-oauth2-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

