/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.extensions;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"authorizationCode", "Lcom/nimbusds/oauth2/sdk/AuthorizationCode;", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "clientIdAsString", "", "expiresIn", "", "Lcom/nimbusds/jwt/SignedJWT;", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "isPrompt", "", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "verifySignatureAndIssuer", "Lcom/nimbusds/jwt/JWTClaimsSet;", "issuer", "Lcom/nimbusds/oauth2/sdk/id/Issuer;", "jwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "mock-oauth2-server"})
public final class NimbusExtensionsKt {
    public static final boolean isPrompt(@NotNull AuthenticationRequest $this$isPrompt) {
        boolean bl;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)$this$isPrompt, (String)"$this$isPrompt");
            Prompt prompt = $this$isPrompt.getPrompt();
            if (prompt != null) {
                Iterable $this$any$iv = (Iterable)prompt;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Prompt.Type it = (Prompt.Type)element$iv;
                        boolean bl2 = false;
                        if (!(it == Prompt.Type.LOGIN || it == Prompt.Type.CONSENT || it == Prompt.Type.SELECT_ACCOUNT)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final GrantType grantType(@NotNull TokenRequest $this$grantType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$grantType, (String)"$this$grantType");
        AuthorizationGrant authorizationGrant = $this$grantType.getAuthorizationGrant();
        if (authorizationGrant == null || (authorizationGrant = authorizationGrant.getType()) == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter grant_type");
        }
        return authorizationGrant;
    }

    @NotNull
    public static final AuthorizationCode authorizationCode(@NotNull TokenRequest $this$authorizationCode) {
        AuthorizationGrant authorizationGrant;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)$this$authorizationCode, (String)"$this$authorizationCode");
                authorizationGrant = $this$authorizationCode.getAuthorizationGrant();
                if (authorizationGrant == null) break block4;
                AuthorizationGrant authorizationGrant2 = authorizationGrant;
                boolean bl = false;
                boolean bl2 = false;
                AuthorizationGrant it = authorizationGrant2;
                boolean bl3 = false;
                AuthorizationGrant authorizationGrant3 = it;
                if (!(authorizationGrant3 instanceof AuthorizationCodeGrant)) {
                    authorizationGrant3 = null;
                }
                if ((authorizationGrant = (AuthorizationCodeGrant)authorizationGrant3) != null && (authorizationGrant = authorizationGrant.getAuthorizationCode()) != null) break block5;
            }
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_GRANT, "code cannot be null");
        }
        return authorizationGrant;
    }

    @NotNull
    public static final String clientIdAsString(@NotNull TokenRequest $this$clientIdAsString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$clientIdAsString, (String)"$this$clientIdAsString");
        Object object = $this$clientIdAsString.getClientAuthentication();
        if (object == null || (object = object.getClientID()) == null || (object = object.getValue()) == null) {
            ClientID clientID = $this$clientIdAsString.getClientID();
            object = clientID != null ? clientID.getValue() : null;
        }
        if (object == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_CLIENT, "client_id cannot be null");
        }
        return object;
    }

    public static final int expiresIn(@NotNull SignedJWT $this$expiresIn) {
        Intrinsics.checkParameterIsNotNull((Object)$this$expiresIn, (String)"$this$expiresIn");
        Temporal temporal = Instant.now();
        JWTClaimsSet jWTClaimsSet = $this$expiresIn.getJWTClaimsSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)jWTClaimsSet, (String)"this.jwtClaimsSet");
        Duration duration = Duration.between(temporal, jWTClaimsSet.getExpirationTime().toInstant());
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.between(Instant\u2026pirationTime.toInstant())");
        return (int)duration.getSeconds();
    }

    @NotNull
    public static final JWTClaimsSet verifySignatureAndIssuer(@NotNull SignedJWT $this$verifySignatureAndIssuer, @NotNull Issuer issuer, @NotNull JWKSet jwkSet) {
        JWTClaimsSet jWTClaimsSet;
        Intrinsics.checkParameterIsNotNull((Object)$this$verifySignatureAndIssuer, (String)"$this$verifySignatureAndIssuer");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)jwkSet, (String)"jwkSet");
        ConfigurableJWTProcessor jwtProcessor = (ConfigurableJWTProcessor)new DefaultJWTProcessor();
        jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("JWT")}));
        JWSKeySelector keySelector = (JWSKeySelector)new JWSVerificationKeySelector(JWSAlgorithm.RS256, (JWKSource)new ImmutableJWKSet(jwkSet));
        jwtProcessor.setJWSKeySelector(keySelector);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer.toString()).build(), (Set)new HashSet(CollectionsKt.listOf((Object[])new String[]{"sub", "iat", "exp", "aud"}))));
        try {
            JWTClaimsSet jWTClaimsSet2 = jwtProcessor.process($this$verifySignatureAndIssuer, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)jWTClaimsSet2, (String)"jwtProcessor.process(this, null)");
            jWTClaimsSet = jWTClaimsSet2;
        }
        catch (Exception e) {
            throw (Throwable)new OAuth2Exception("invalid signed JWT.", e);
        }
        return jWTClaimsSet;
    }
}

