/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minidev.json.JSONObject;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandler;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler;
import no.nav.security.mock.oauth2.grant.ClientCredentialsGrantHandler;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.JwtBearerGrantHandler;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandlerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.WellKnown;
import no.nav.security.mock.oauth2.login.Login;
import no.nav.security.mock.oauth2.login.LoginRequestHandler;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler;", "", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "debuggerRequestHandler", "Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler;", "grantHandlers", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "loginRequestHandler", "Lno/nav/security/mock/oauth2/login/LoginRequestHandler;", "oAuth2TokenCallbackQueue", "Ljava/util/concurrent/BlockingQueue;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueTokenCallback", "", "oAuth2TokenCallback", "grantHandler", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "authenticationRequest", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "handleException", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "error", "", "handleRequest", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "takeTokenCallbackOrCreateDefault", "issuerId", "", "wellKnown", "Lno/nav/security/mock/oauth2/http/WellKnown;", "mock-oauth2-server"})
public final class OAuth2HttpRequestHandler {
    private final LoginRequestHandler loginRequestHandler;
    private final DebuggerRequestHandler debuggerRequestHandler;
    private final BlockingQueue<OAuth2TokenCallback> oAuth2TokenCallbackQueue;
    private final Map<GrantType, GrantHandler> grantHandlers;
    private final OAuth2Config config;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final OAuth2HttpResponse handleRequest(@NotNull OAuth2HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this;
        boolean bl = false;
        try {
            OAuth2HttpResponse oAuth2HttpResponse;
            Result.Companion companion = Result.Companion;
            OAuth2HttpRequestHandler $this$runCatching = object;
            boolean bl2 = false;
            OAuth2HttpRequestHandlerKt.access$getLog$p().debug("received request on url=" + request.getUrl() + " with headers=" + request.getHeaders());
            HttpUrl url = request.getUrl();
            if (HttpUrlExtensionsKt.isWellKnownUrl(url)) {
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("returning well-known json data for url=" + url);
                return OAuth2HttpResponseKt.json($this$runCatching.wellKnown(request));
            }
            if (HttpUrlExtensionsKt.isAuthorizationEndpointUrl(url)) {
                OAuth2HttpResponse oAuth2HttpResponse2;
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("received call to authorization endpoint");
                AuthenticationRequest authRequest = request.asAuthenticationRequest();
                GrantHandler grantHandler = $this$runCatching.grantHandler(authRequest);
                if (grantHandler == null) {
                    throw new NullPointerException("null cannot be cast to non-null type no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler");
                }
                AuthorizationCodeHandler authorizationCodeHandler = (AuthorizationCodeHandler)grantHandler;
                String string = request.getMethod();
                switch (string.hashCode()) {
                    case 2461856: {
                        if (!string.equals("POST")) throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "Unsupported request method " + request.getMethod());
                        break;
                    }
                    case 70454: {
                        if (!string.equals("GET")) throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "Unsupported request method " + request.getMethod());
                        oAuth2HttpResponse2 = $this$runCatching.config.getInteractiveLogin() || NimbusExtensionsKt.isPrompt(authRequest) ? OAuth2HttpResponseKt.html($this$runCatching.loginRequestHandler.loginHtml(request)) : OAuth2HttpResponseKt.authenticationSuccess(AuthorizationCodeHandler.authorizationCodeResponse$default(authorizationCodeHandler, authRequest, null, 2, null));
                        return oAuth2HttpResponse2;
                    }
                }
                Login login = $this$runCatching.loginRequestHandler.loginSubmit(request);
                oAuth2HttpResponse2 = OAuth2HttpResponseKt.authenticationSuccess(authorizationCodeHandler.authorizationCodeResponse(authRequest, login));
                return oAuth2HttpResponse2;
                throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "Unsupported request method " + request.getMethod());
            }
            if (HttpUrlExtensionsKt.isTokenEndpointUrl(url)) {
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle token request " + request);
                OAuth2TokenCallback oAuth2TokenCallback = $this$runCatching.takeTokenCallbackOrCreateDefault(HttpUrlExtensionsKt.issuerId(request.getUrl()));
                TokenRequest tokenRequest = request.asTokenRequest();
                oAuth2HttpResponse = OAuth2HttpResponseKt.json($this$runCatching.grantHandler(tokenRequest).tokenResponse(tokenRequest, HttpUrlExtensionsKt.toIssuerUrl(request.getUrl()), oAuth2TokenCallback));
                return oAuth2HttpResponse;
            } else if (HttpUrlExtensionsKt.isEndSessionEndpointUrl(url)) {
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle end session request " + request);
                String string = request.getUrl().queryParameter("post_logout_redirect_uri");
                if (string == null) {
                    string = "https://www.nav.no";
                }
                String postLogoutRedirectUri = string;
                oAuth2HttpResponse = OAuth2HttpResponseKt.redirect$default(postLogoutRedirectUri, null, 2, null);
                return oAuth2HttpResponse;
            } else {
                if (HttpUrlExtensionsKt.isJwksUrl(url)) {
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle jwks request");
                    JSONObject jSONObject = $this$runCatching.config.getTokenProvider().publicJwkSet().toJSONObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"config.tokenProvider.publicJwkSet().toJSONObject()");
                    return OAuth2HttpResponseKt.json(jSONObject);
                }
                if (HttpUrlExtensionsKt.isDebuggerUrl(url)) {
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle debugger request");
                    return $this$runCatching.debuggerRequestHandler.handleDebuggerForm(request);
                }
                if (HttpUrlExtensionsKt.isDebuggerCallbackUrl(url)) {
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle debugger callback request");
                    return $this$runCatching.debuggerRequestHandler.handleDebuggerCallback(request);
                }
                if (Intrinsics.areEqual((Object)url.encodedPath(), (Object)"/favicon.ico")) {
                    return new OAuth2HttpResponse(null, 200, null, 5, null);
                }
                String msg = "path '" + request.getUrl() + "' not found";
                OAuth2HttpRequestHandlerKt.access$getLog$p().error(msg);
                return OAuth2HttpResponseKt.notFound();
            }
        }
        catch (Throwable $this$runCatching) {
            OAuth2HttpResponse oAuth2HttpResponse;
            Object object2;
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
            bl = false;
            boolean bl4 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                Void result = (Void)object;
                boolean bl5 = false;
                oAuth2HttpResponse = (OAuth2HttpResponse)((Object)result);
                return oAuth2HttpResponse;
            } else {
                Throwable error = throwable;
                boolean bl6 = false;
                oAuth2HttpResponse = this.handleException(error);
            }
            return oAuth2HttpResponse;
        }
    }

    public final boolean enqueueTokenCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        return this.oAuth2TokenCallbackQueue.add(oAuth2TokenCallback);
    }

    private final OAuth2TokenCallback takeTokenCallbackOrCreateDefault(String issuerId) {
        OAuth2TokenCallback oAuth2TokenCallback;
        Object v2;
        block3: {
            OAuth2TokenCallback oAuth2TokenCallback2 = (OAuth2TokenCallback)this.oAuth2TokenCallbackQueue.peek();
            if (Intrinsics.areEqual((Object)(oAuth2TokenCallback2 != null ? oAuth2TokenCallback2.issuerId() : null), (Object)issuerId)) {
                OAuth2TokenCallback oAuth2TokenCallback3 = this.oAuth2TokenCallbackQueue.take();
                Intrinsics.checkNotNullExpressionValue((Object)oAuth2TokenCallback3, (String)"oAuth2TokenCallbackQueue.take()");
                return oAuth2TokenCallback3;
            }
            Iterable $this$firstOrNull$iv = this.config.getOAuth2TokenCallbacks();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OAuth2TokenCallback it = (OAuth2TokenCallback)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.issuerId(), (Object)issuerId)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((oAuth2TokenCallback = (OAuth2TokenCallback)v2) == null) {
            oAuth2TokenCallback = new DefaultOAuth2TokenCallback(issuerId, null, null, null, 0L, 30, null);
        }
        return oAuth2TokenCallback;
    }

    private final OAuth2HttpResponse handleException(Throwable error) {
        ErrorObject errorObject;
        Object object;
        OAuth2HttpRequestHandlerKt.access$getLog$p().error("received exception when handling request.", error);
        Throwable throwable = error;
        if (throwable instanceof OAuth2Exception) {
            object = ((OAuth2Exception)error).getErrorObject();
        } else if (throwable instanceof ParseException) {
            object = ((ParseException)error).getErrorObject();
            if (object == null) {
                object = OAuth2Error.INVALID_REQUEST.appendDescription(". received exception message: " + error.getMessage());
            }
        } else {
            object = errorObject = throwable instanceof GeneralException ? ((GeneralException)error).getErrorObject() : null;
        }
        if (object == null) {
            ErrorObject errorObject2 = OAuth2Error.SERVER_ERROR.appendDescription(". received exception message: " + error.getMessage());
            errorObject = errorObject2;
            Intrinsics.checkNotNullExpressionValue((Object)errorObject2, (String)"OAuth2Error.SERVER_ERROR\u2026ssage: ${error.message}\")");
        }
        ErrorObject errorObject3 = errorObject;
        return OAuth2HttpResponseKt.oauth2Error(errorObject3);
    }

    private final GrantHandler grantHandler(AuthenticationRequest authenticationRequest) {
        GrantHandler grantHandler;
        if (authenticationRequest.getResponseType().impliesCodeFlow()) {
            grantHandler = this.grantHandlers.get(GrantType.AUTHORIZATION_CODE);
            if (grantHandler == null) {
                throw new NullPointerException("null cannot be cast to non-null type no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler");
            }
        } else {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_GRANT, "hybrid og implicit flow not supported (yet).");
        }
        return (AuthorizationCodeHandler)grantHandler;
    }

    private final GrantHandler grantHandler(TokenRequest tokenRequest) {
        GrantHandler grantHandler = this.grantHandlers.get(NimbusExtensionsKt.grantType(tokenRequest));
        if (grantHandler == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_GRANT, "grant_type " + NimbusExtensionsKt.grantType(tokenRequest) + " not supported.");
        }
        return grantHandler;
    }

    private final WellKnown wellKnown(OAuth2HttpRequest request) {
        List list = null;
        List list2 = null;
        List list3 = null;
        String string = HttpUrlExtensionsKt.toJwksUrl(request.getUrl()).toString();
        String string2 = HttpUrlExtensionsKt.toEndSessionEndpointUrl(request.getUrl()).toString();
        String string3 = HttpUrlExtensionsKt.toTokenEndpointUrl(request.getUrl()).toString();
        return new WellKnown(HttpUrlExtensionsKt.toIssuerUrl(request.getUrl()).toString(), HttpUrlExtensionsKt.toAuthorizationEndpointUrl(request.getUrl()).toString(), string2, string3, string, list3, list2, list, 224, null);
    }

    public OAuth2HttpRequestHandler(@NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.loginRequestHandler = new LoginRequestHandler(OAuth2HttpResponseKt.getTemplateMapper());
        this.debuggerRequestHandler = new DebuggerRequestHandler(OAuth2HttpResponseKt.getTemplateMapper());
        this.oAuth2TokenCallbackQueue = new LinkedBlockingQueue();
        this.grantHandlers = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)GrantType.AUTHORIZATION_CODE, (Object)new AuthorizationCodeHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.CLIENT_CREDENTIALS, (Object)new ClientCredentialsGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.JWT_BEARER, (Object)new JwtBearerGrantHandler(this.config.getTokenProvider()))});
    }
}

