/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.extensions;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2Exception;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000e\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a#\u0010\u000b\u001a\u00020\f*\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000e\"\u00020\n\u00a2\u0006\u0002\u0010\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\n\u0010\u0012\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0002*\u00020\u0002\u001a\f\u0010\u001b\u001a\u00020\u0002*\u00020\u0002H\u0002\u00a8\u0006\u001c"}, d2={"isAuthorizationEndpointUrl", "", "Lokhttp3/HttpUrl;", "isDebuggerCallbackUrl", "isDebuggerUrl", "isEndSessionEndpointUrl", "isJwksUrl", "isTokenEndpointUrl", "isWellKnownUrl", "issuerId", "", "removeAllEncodedQueryParams", "Lokhttp3/HttpUrl$Builder;", "params", "", "(Lokhttp3/HttpUrl$Builder;[Ljava/lang/String;)Lokhttp3/HttpUrl$Builder;", "resolvePath", "path", "toAuthorizationEndpointUrl", "toDebuggerCallbackUrl", "toDebuggerUrl", "toEndSessionEndpointUrl", "toIssuerUrl", "toJwksUrl", "toOAuth2AuthorizationServerMetadataUrl", "toTokenEndpointUrl", "toWellKnownUrl", "withoutQuery", "mock-oauth2-server"})
public final class HttpUrlExtensionsKt {
    public static final boolean isWellKnownUrl(@NotNull HttpUrl $this$isWellKnownUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isWellKnownUrl, (String)"$this$isWellKnownUrl");
        return Intrinsics.areEqual((Object)$this$isWellKnownUrl, (Object)HttpUrlExtensionsKt.toWellKnownUrl($this$isWellKnownUrl)) || Intrinsics.areEqual((Object)$this$isWellKnownUrl, (Object)HttpUrlExtensionsKt.toOAuth2AuthorizationServerMetadataUrl($this$isWellKnownUrl));
    }

    public static final boolean isAuthorizationEndpointUrl(@NotNull HttpUrl $this$isAuthorizationEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isAuthorizationEndpointUrl, (String)"$this$isAuthorizationEndpointUrl");
        return Intrinsics.areEqual((Object)HttpUrlExtensionsKt.withoutQuery($this$isAuthorizationEndpointUrl), (Object)HttpUrlExtensionsKt.toAuthorizationEndpointUrl($this$isAuthorizationEndpointUrl));
    }

    public static final boolean isTokenEndpointUrl(@NotNull HttpUrl $this$isTokenEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isTokenEndpointUrl, (String)"$this$isTokenEndpointUrl");
        return Intrinsics.areEqual((Object)$this$isTokenEndpointUrl, (Object)HttpUrlExtensionsKt.toTokenEndpointUrl($this$isTokenEndpointUrl));
    }

    public static final boolean isEndSessionEndpointUrl(@NotNull HttpUrl $this$isEndSessionEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isEndSessionEndpointUrl, (String)"$this$isEndSessionEndpointUrl");
        return Intrinsics.areEqual((Object)HttpUrlExtensionsKt.withoutQuery($this$isEndSessionEndpointUrl), (Object)HttpUrlExtensionsKt.toEndSessionEndpointUrl($this$isEndSessionEndpointUrl));
    }

    public static final boolean isJwksUrl(@NotNull HttpUrl $this$isJwksUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isJwksUrl, (String)"$this$isJwksUrl");
        return Intrinsics.areEqual((Object)$this$isJwksUrl, (Object)HttpUrlExtensionsKt.toJwksUrl($this$isJwksUrl));
    }

    public static final boolean isDebuggerUrl(@NotNull HttpUrl $this$isDebuggerUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebuggerUrl, (String)"$this$isDebuggerUrl");
        return Intrinsics.areEqual((Object)HttpUrlExtensionsKt.withoutQuery($this$isDebuggerUrl), (Object)HttpUrlExtensionsKt.toDebuggerUrl($this$isDebuggerUrl));
    }

    public static final boolean isDebuggerCallbackUrl(@NotNull HttpUrl $this$isDebuggerCallbackUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebuggerCallbackUrl, (String)"$this$isDebuggerCallbackUrl");
        return Intrinsics.areEqual((Object)HttpUrlExtensionsKt.withoutQuery($this$isDebuggerCallbackUrl), (Object)HttpUrlExtensionsKt.toDebuggerCallbackUrl($this$isDebuggerCallbackUrl));
    }

    @NotNull
    public static final HttpUrl toOAuth2AuthorizationServerMetadataUrl(@NotNull HttpUrl $this$toOAuth2AuthorizationServerMetadataUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toOAuth2AuthorizationServerMetadataUrl, (String)"$this$toOAuth2AuthorizationServerMetadataUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toOAuth2AuthorizationServerMetadataUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toOAuth2AuthorizationServerMetadataUrl) + "/.well-known/oauth-authorization-server");
    }

    @NotNull
    public static final HttpUrl toWellKnownUrl(@NotNull HttpUrl $this$toWellKnownUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toWellKnownUrl, (String)"$this$toWellKnownUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toWellKnownUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toWellKnownUrl) + "/.well-known/openid-configuration");
    }

    @NotNull
    public static final HttpUrl toAuthorizationEndpointUrl(@NotNull HttpUrl $this$toAuthorizationEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toAuthorizationEndpointUrl, (String)"$this$toAuthorizationEndpointUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toAuthorizationEndpointUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toAuthorizationEndpointUrl) + "/authorize");
    }

    @NotNull
    public static final HttpUrl toEndSessionEndpointUrl(@NotNull HttpUrl $this$toEndSessionEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toEndSessionEndpointUrl, (String)"$this$toEndSessionEndpointUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toEndSessionEndpointUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toEndSessionEndpointUrl) + "/endsession");
    }

    @NotNull
    public static final HttpUrl toTokenEndpointUrl(@NotNull HttpUrl $this$toTokenEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toTokenEndpointUrl, (String)"$this$toTokenEndpointUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toTokenEndpointUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toTokenEndpointUrl) + "/token");
    }

    @NotNull
    public static final HttpUrl toJwksUrl(@NotNull HttpUrl $this$toJwksUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toJwksUrl, (String)"$this$toJwksUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toJwksUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toJwksUrl) + "/jwks");
    }

    @NotNull
    public static final HttpUrl toIssuerUrl(@NotNull HttpUrl $this$toIssuerUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toIssuerUrl, (String)"$this$toIssuerUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toIssuerUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toIssuerUrl));
    }

    @NotNull
    public static final HttpUrl toDebuggerUrl(@NotNull HttpUrl $this$toDebuggerUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerUrl, (String)"$this$toDebuggerUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toDebuggerUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toDebuggerUrl) + "/debugger");
    }

    @NotNull
    public static final HttpUrl toDebuggerCallbackUrl(@NotNull HttpUrl $this$toDebuggerCallbackUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerCallbackUrl, (String)"$this$toDebuggerCallbackUrl");
        return HttpUrlExtensionsKt.resolvePath($this$toDebuggerCallbackUrl, '/' + HttpUrlExtensionsKt.issuerId($this$toDebuggerCallbackUrl) + "/debugger/callback");
    }

    @NotNull
    public static final String issuerId(@NotNull HttpUrl $this$issuerId) {
        Intrinsics.checkNotNullParameter((Object)$this$issuerId, (String)"$this$issuerId");
        String string = (String)CollectionsKt.getOrNull((List)$this$issuerId.pathSegments(), (int)0);
        if (string == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "issuerId must be first segment in url path");
        }
        return string;
    }

    @NotNull
    public static final HttpUrl.Builder removeAllEncodedQueryParams(@NotNull HttpUrl.Builder $this$removeAllEncodedQueryParams, String ... params) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAllEncodedQueryParams, (String)"$this$removeAllEncodedQueryParams");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpUrl.Builder builder = $this$removeAllEncodedQueryParams;
        boolean bl = false;
        boolean bl2 = false;
        HttpUrl.Builder $this$apply = builder;
        boolean bl3 = false;
        String[] $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl4 = false;
            $this$apply.removeAllEncodedQueryParameters(it);
        }
        return builder;
    }

    private static final HttpUrl withoutQuery(HttpUrl $this$withoutQuery) {
        return $this$withoutQuery.newBuilder().query(null).build();
    }

    private static final HttpUrl resolvePath(HttpUrl $this$resolvePath, String path) {
        HttpUrl httpUrl = new HttpUrl.Builder().scheme($this$resolvePath.scheme()).host($this$resolvePath.host()).port($this$resolvePath.port()).build().resolve(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        if (httpUrl == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "cannot resolve path " + path);
        }
        return httpUrl;
    }
}

