/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.TokenRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantHandlerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lno/nav/security/mock/oauth2/grant/TokenExchangeGrantHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;)V", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "mock-oauth2-server"})
public final class TokenExchangeGrantHandler
implements GrantHandler {
    private final OAuth2TokenProvider tokenProvider;

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        JWTClaimsSet receivedClaimsSet;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asTokenExchangeRequest();
        JWTClaimsSet jWTClaimsSet = receivedClaimsSet = TokenExchangeGrantHandlerKt.subjectToken(tokenRequest).getJWTClaimsSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"receivedClaimsSet");
        SignedJWT accessToken = this.tokenProvider.exchangeAccessToken(tokenRequest, issuerUrl, jWTClaimsSet, oAuth2TokenCallback);
        return new OAuth2TokenResponse("Bearer", "urn:ietf:params:oauth:token-type:access_token", null, accessToken.serialize(), null, NimbusExtensionsKt.expiresIn(accessToken), null, 84, null);
    }

    public TokenExchangeGrantHandler(@NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        this.tokenProvider = tokenProvider;
    }
}

