/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.MockOAuth2Dispatcher;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJH\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u00122\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010!2\b\b\u0002\u0010\"\u001a\u00020#H\u0007J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0018J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010(\u001a\u00020)J\u001c\u0010*\u001a\u00020)2\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.H\u0007J\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0012J\u000e\u00104\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lno/nav/security/mock/oauth2/MockOAuth2Server;", "", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "getConfig", "()Lno/nav/security/mock/oauth2/OAuth2Config;", "dispatcher", "Lokhttp3/mockwebserver/Dispatcher;", "getDispatcher", "()Lokhttp3/mockwebserver/Dispatcher;", "setDispatcher", "(Lokhttp3/mockwebserver/Dispatcher;)V", "mockWebServer", "Lokhttp3/mockwebserver/MockWebServer;", "authorizationEndpointUrl", "Lokhttp3/HttpUrl;", "issuerId", "", "baseUrl", "endSessionEndpointUrl", "enqueueCallback", "", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueResponse", "response", "Lokhttp3/mockwebserver/MockResponse;", "issueToken", "Lcom/nimbusds/jwt/SignedJWT;", "subject", "audience", "claims", "", "expiry", "", "clientId", "tokenCallback", "issuerUrl", "jwksUrl", "shutdown", "", "start", "inetAddress", "Ljava/net/InetAddress;", "port", "", "takeRequest", "Lokhttp3/mockwebserver/RecordedRequest;", "tokenEndpointUrl", "url", "path", "wellKnownUrl", "mock-oauth2-server"})
public final class MockOAuth2Server {
    private final MockWebServer mockWebServer;
    @NotNull
    private Dispatcher dispatcher;
    @NotNull
    private final OAuth2Config config;

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"<set-?>");
        this.dispatcher = dispatcher;
    }

    @JvmOverloads
    public final void start(@NotNull InetAddress inetAddress, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        this.mockWebServer.start(inetAddress, port);
        this.mockWebServer.setDispatcher(this.dispatcher);
    }

    public static /* synthetic */ void start$default(MockOAuth2Server mockOAuth2Server, InetAddress inetAddress, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            InetAddress inetAddress2 = InetAddress.getByName("localhost");
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"InetAddress.getByName(\"localhost\")");
            inetAddress = inetAddress2;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        mockOAuth2Server.start(inetAddress, n);
    }

    @JvmOverloads
    public final void start(@NotNull InetAddress inetAddress) throws IOException {
        MockOAuth2Server.start$default(this, inetAddress, 0, 2, null);
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockOAuth2Server.start$default(this, null, 0, 3, null);
    }

    public final void shutdown() throws IOException {
        this.mockWebServer.shutdown();
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.mockWebServer.url(path);
    }

    public final boolean enqueueResponse(@NotNull MockResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher == null) {
            throw new NullPointerException("null cannot be cast to non-null type no.nav.security.mock.oauth2.MockOAuth2Dispatcher");
        }
        return ((MockOAuth2Dispatcher)dispatcher).enqueueResponse(response);
    }

    public final boolean enqueueCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher == null) {
            throw new NullPointerException("null cannot be cast to non-null type no.nav.security.mock.oauth2.MockOAuth2Dispatcher");
        }
        return ((MockOAuth2Dispatcher)dispatcher).enqueueTokenCallback(oAuth2TokenCallback);
    }

    @NotNull
    public final RecordedRequest takeRequest() {
        return this.mockWebServer.takeRequest();
    }

    @NotNull
    public final HttpUrl wellKnownUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toWellKnownUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl tokenEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toTokenEndpointUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl jwksUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toJwksUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl issuerUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return this.mockWebServer.url(issuerId);
    }

    @NotNull
    public final HttpUrl authorizationEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl endSessionEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toEndSessionEndpointUrl(this.mockWebServer.url(issuerId));
    }

    @NotNull
    public final HttpUrl baseUrl() {
        return this.mockWebServer.url("");
    }

    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String clientId, @NotNull OAuth2TokenCallback tokenCallback) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)tokenCallback, (String)"tokenCallback");
        HttpUrl uri = this.tokenEndpointUrl(issuerId);
        HttpUrl issuerUrl = this.issuerUrl(issuerId);
        TokenRequest tokenRequest = new TokenRequest(uri.uri(), (ClientAuthentication)new ClientSecretBasic(new ClientID(clientId), new Secret("secret")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("123"), URI.create("http://localhost")));
        return this.config.getTokenProvider().accessToken(tokenRequest, issuerUrl, tokenCallback, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience, @NotNull Map<String, ? extends Object> claims, long expiry) {
        List list;
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        MockOAuth2Server mockOAuth2Server = this;
        String string = issuerId;
        String string2 = "default";
        String string3 = issuerId;
        String string4 = subject;
        String string5 = audience;
        if (string5 != null) {
            void it;
            String string6 = string5;
            boolean bl = false;
            boolean bl2 = false;
            String string7 = string6;
            String string8 = string4;
            String string9 = string3;
            String string10 = string2;
            String string11 = string;
            MockOAuth2Server mockOAuth2Server2 = mockOAuth2Server;
            boolean bl3 = false;
            List list2 = CollectionsKt.listOf((Object)it);
            mockOAuth2Server = mockOAuth2Server2;
            string = string11;
            string2 = string10;
            string3 = string9;
            string4 = string8;
            list = list2;
        } else {
            list = null;
        }
        long l = expiry;
        Map<String, ? extends Object> map = claims;
        List list3 = list;
        String string12 = string4;
        String string13 = string3;
        return mockOAuth2Server.issueToken(string, string2, new DefaultOAuth2TokenCallback(string13, string12, list3, map, l));
    }

    public static /* synthetic */ SignedJWT issueToken$default(MockOAuth2Server mockOAuth2Server, String string, String string2, String string3, Map map, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = "default";
        }
        if ((n & 2) != 0) {
            String string4 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"UUID.randomUUID().toString()");
            string2 = string4;
        }
        if ((n & 4) != 0) {
            string3 = "default";
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            l = 3600L;
        }
        return mockOAuth2Server.issueToken(string, string2, string3, map, l);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience, @NotNull Map<String, ? extends Object> claims) {
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, audience, claims, 0L, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience) {
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, audience, null, 0L, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject) {
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, null, null, 0L, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId) {
        return MockOAuth2Server.issueToken$default(this, issuerId, null, null, null, 0L, 30, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken() {
        return MockOAuth2Server.issueToken$default(this, null, null, null, null, 0L, 31, null);
    }

    @NotNull
    public final OAuth2Config getConfig() {
        return this.config;
    }

    public MockOAuth2Server(@NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.mockWebServer = new MockWebServer();
        this.dispatcher = new MockOAuth2Dispatcher(this.config);
    }

    public /* synthetic */ MockOAuth2Server(OAuth2Config oAuth2Config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            oAuth2Config = new OAuth2Config(false, null, null, 7, null);
        }
        this(oAuth2Config);
    }

    public MockOAuth2Server() {
        this(null, 1, null);
    }
}

