/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandlerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\r\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\u000e\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a \u0010\u0010\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\f\u0010\u0012\u001a\u00020\n*\u00020\nH\u0002\u001a \u0010\u0012\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"client", "Lokhttp3/OkHttpClient;", "log", "Lmu/KLogger;", "debuggerAuthorizationRequest", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "authEndpointUrl", "Lokhttp3/HttpUrl;", "redirectUrl", "decrypt", "", "key", "Ljavax/crypto/SecretKey;", "encrypt", "require", "", "toKeyValueString", "entrySeparator", "urlEncode", "mock-oauth2-server"})
public final class DebuggerRequestHandlerKt {
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    private static final OkHttpClient client = new OkHttpClient().newBuilder().followRedirects(false).build();

    private static final OAuth2HttpRequest debuggerAuthorizationRequest(HttpUrl authEndpointUrl, HttpUrl redirectUrl) {
        HttpUrl httpUrl = authEndpointUrl.newBuilder().addQueryParameter("client_id", "debugger").addQueryParameter("response_type", "code").addQueryParameter("redirect_uri", redirectUrl.toString()).addQueryParameter("response_mode", "query").addQueryParameter("scope", "openid somescope").addQueryParameter("state", "1234").addQueryParameter("nonce", "5678").build();
        boolean bl = false;
        boolean bl2 = false;
        HttpUrl it = httpUrl;
        boolean bl3 = false;
        return new OAuth2HttpRequest(Headers.Companion.of(new String[0]), "GET", it, null, 8, null);
    }

    private static final String urlEncode(String $this$urlEncode) {
        String string = URLEncoder.encode($this$urlEncode, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(this, StandardCharsets.UTF_8)");
        return string;
    }

    private static final String require(Map<String, String> $this$require, String key) {
        String string = $this$require.get(key);
        if (string == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter " + key);
        }
        return string;
    }

    private static final String urlEncode(Map<String, String> $this$urlEncode, String key) {
        return DebuggerRequestHandlerKt.urlEncode(DebuggerRequestHandlerKt.require($this$urlEncode, key));
    }

    /*
     * WARNING - void declaration
     */
    private static final String toKeyValueString(Map<String, String> $this$toKeyValueString, String entrySeparator) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = $this$toKeyValueString;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv)), (CharSequence)entrySeparator, null, null, (int)0, null, null, (int)62, null);
    }

    private static final String encrypt(String $this$encrypt, SecretKey key) {
        JWEObject jWEObject = new JWEObject(new JWEHeader(JWEAlgorithm.DIR, EncryptionMethod.A128GCM), new Payload($this$encrypt));
        boolean bl = false;
        boolean bl2 = false;
        JWEObject it = jWEObject;
        boolean bl3 = false;
        it.encrypt((JWEEncrypter)new DirectEncrypter(key));
        String string = jWEObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JWEObject(\n        JWEHe\u2026r(key))\n    }.serialize()");
        return string;
    }

    private static final String decrypt(String $this$decrypt, SecretKey key) {
        JWEObject jWEObject = JWEObject.parse((String)$this$decrypt);
        boolean bl = false;
        boolean bl2 = false;
        JWEObject it = jWEObject;
        boolean bl3 = false;
        it.decrypt((JWEDecrypter)new DirectDecrypter(key));
        JWEObject jWEObject2 = jWEObject;
        Intrinsics.checkNotNullExpressionValue((Object)jWEObject2, (String)"JWEObject.parse(this).al\u2026rectDecrypter(key))\n    }");
        String string = jWEObject2.getPayload().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JWEObject.parse(this).al\u2026\n    }.payload.toString()");
        return string;
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ OAuth2HttpRequest access$debuggerAuthorizationRequest(HttpUrl authEndpointUrl, HttpUrl redirectUrl) {
        return DebuggerRequestHandlerKt.debuggerAuthorizationRequest(authEndpointUrl, redirectUrl);
    }

    public static final /* synthetic */ String access$encrypt(String $this$access_u24encrypt, SecretKey key) {
        return DebuggerRequestHandlerKt.encrypt($this$access_u24encrypt, key);
    }

    public static final /* synthetic */ String access$toKeyValueString(Map $this$access_u24toKeyValueString, String entrySeparator) {
        return DebuggerRequestHandlerKt.toKeyValueString($this$access_u24toKeyValueString, entrySeparator);
    }

    public static final /* synthetic */ String access$urlEncode(Map $this$access_u24urlEncode, String key) {
        return DebuggerRequestHandlerKt.urlEncode($this$access_u24urlEncode, key);
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p() {
        return client;
    }

    public static final /* synthetic */ String access$decrypt(String $this$access_u24decrypt, SecretKey key) {
        return DebuggerRequestHandlerKt.decrypt($this$access_u24decrypt, key);
    }

    public static final /* synthetic */ String access$urlEncode(String $this$access_u24urlEncode) {
        return DebuggerRequestHandlerKt.urlEncode($this$access_u24urlEncode);
    }

    public static final /* synthetic */ String access$require(Map $this$access_u24require, String key) {
        return DebuggerRequestHandlerKt.require($this$access_u24require, key);
    }
}

