/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.extensions.StringKt;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrant;
import no.nav.security.mock.oauth2.http.RequestType;
import no.nav.security.mock.oauth2.http.WellKnown;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J3\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00062"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "headers", "Lokhttp3/Headers;", "method", "", "url", "Lokhttp3/HttpUrl;", "body", "(Lokhttp3/Headers;Ljava/lang/String;Lokhttp3/HttpUrl;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "cookies", "", "getCookies", "()Ljava/util/Map;", "formParameters", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "getFormParameters", "()Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "getHeaders", "()Lokhttp3/Headers;", "getMethod", "getUrl", "()Lokhttp3/HttpUrl;", "asAuthenticationRequest", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "asNimbusHTTPRequest", "Lcom/nimbusds/oauth2/sdk/http/HTTPRequest;", "asNimbusTokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "asTokenExchangeRequest", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "hashCode", "", "toString", "toWellKnown", "Lno/nav/security/mock/oauth2/http/WellKnown;", "type", "Lno/nav/security/mock/oauth2/http/RequestType;", "Parameters", "mock-oauth2-server"})
public final class OAuth2HttpRequest {
    @NotNull
    private final Parameters formParameters;
    @NotNull
    private final Map<String, String> cookies;
    @NotNull
    private final Headers headers;
    @NotNull
    private final String method;
    @NotNull
    private final HttpUrl url;
    @Nullable
    private final String body;

    @NotNull
    public final Parameters getFormParameters() {
        return this.formParameters;
    }

    @NotNull
    public final Map<String, String> getCookies() {
        return this.cookies;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TokenRequest asTokenExchangeRequest() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        HTTPRequest httpRequest = this.asNimbusHTTPRequest();
        ClientAuthentication clientAuthentication = ClientAuthentication.parse((HTTPRequest)httpRequest);
        Intrinsics.checkNotNullExpressionValue((Object)clientAuthentication, (String)"ClientAuthentication.parse(httpRequest)");
        PrivateKeyJWT clientAuthentication2 = NimbusExtensionsKt.requirePrivateKeyJwt(clientAuthentication, this.url.toString(), 120L);
        TokenExchangeGrant tokenExchangeGrant = TokenExchangeGrant.Companion.parse(this.formParameters.getMap());
        Map<String, String> map2 = this.formParameters.getMap();
        List list = CollectionsKt.emptyList();
        Scope scope = null;
        AuthorizationGrant authorizationGrant = tokenExchangeGrant;
        ClientAuthentication clientAuthentication3 = (ClientAuthentication)clientAuthentication2;
        URI uRI = this.url.uri();
        boolean $i$f$mapValues = false;
        void var6_11 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            boolean bl2 = false;
            List list2 = CollectionsKt.mutableListOf((Object[])new String[]{(String)it.getValue()});
            map.put(k2, list2);
        }
        Map map4 = map = destination$iv$iv;
        List list3 = list;
        Scope scope2 = scope;
        AuthorizationGrant authorizationGrant2 = authorizationGrant;
        ClientAuthentication clientAuthentication4 = clientAuthentication3;
        URI uRI2 = uRI;
        return new TokenRequest(uRI2, clientAuthentication4, authorizationGrant2, scope2, list3, map4);
    }

    @NotNull
    public final HTTPRequest asNimbusHTTPRequest() {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.valueOf((String)this.method), this.url.url());
        boolean bl = false;
        boolean bl2 = false;
        HTTPRequest $this$apply = hTTPRequest;
        boolean bl3 = false;
        Iterable $this$forEach$iv = (Iterable)this.headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair header = (Pair)element$iv;
            boolean bl4 = false;
            $this$apply.setHeader((String)header.getFirst(), new String[]{(String)header.getSecond()});
        }
        $this$apply.setQuery(this.body);
        return hTTPRequest;
    }

    @NotNull
    public final TokenRequest asNimbusTokenRequest() {
        TokenRequest tokenRequest = TokenRequest.parse((HTTPRequest)this.asNimbusHTTPRequest());
        Intrinsics.checkNotNullExpressionValue((Object)tokenRequest, (String)"TokenRequest.parse(\n    \u2026usHTTPRequest()\n        )");
        return tokenRequest;
    }

    @NotNull
    public final AuthenticationRequest asAuthenticationRequest() {
        AuthenticationRequest authenticationRequest = AuthenticationRequest.parse((URI)this.url.uri());
        Intrinsics.checkNotNullExpressionValue((Object)authenticationRequest, (String)"AuthenticationRequest.parse(this.url.toUri())");
        return authenticationRequest;
    }

    @NotNull
    public final RequestType type() {
        return HttpUrlExtensionsKt.isWellKnownUrl(this.url) ? RequestType.WELL_KNOWN : (HttpUrlExtensionsKt.isAuthorizationEndpointUrl(this.url) ? RequestType.AUTHORIZATION : (HttpUrlExtensionsKt.isTokenEndpointUrl(this.url) ? RequestType.TOKEN : (HttpUrlExtensionsKt.isEndSessionEndpointUrl(this.url) ? RequestType.END_SESSION : (HttpUrlExtensionsKt.isJwksUrl(this.url) ? RequestType.JWKS : (HttpUrlExtensionsKt.isDebuggerUrl(this.url) ? RequestType.DEBUGGER : (HttpUrlExtensionsKt.isDebuggerCallbackUrl(this.url) ? RequestType.DEBUGGER_CALLBACK : (Intrinsics.areEqual((Object)this.url.encodedPath(), (Object)"/favicon.ico") ? RequestType.FAVICON : RequestType.UNKNOWN)))))));
    }

    @NotNull
    public final GrantType grantType() {
        boolean bl;
        CharSequence charSequence;
        String string;
        block6: {
            block5: {
                CharSequence charSequence2;
                string = this.formParameters.getMap().get("grant_type");
                if (string == null) break block5;
                charSequence = string;
                bl = false;
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    boolean bl2 = false;
                    charSequence2 = null;
                } else {
                    charSequence2 = charSequence;
                }
                if ((string = (String)charSequence2) != null) break block6;
            }
            Void void_ = OAuth2ExceptionKt.missingParameter("grant_type");
            throw new KotlinNothingValueException();
        }
        charSequence = string;
        bl = false;
        boolean bl3 = false;
        CharSequence it = charSequence;
        boolean bl4 = false;
        return new GrantType((String)it);
    }

    @NotNull
    public final WellKnown toWellKnown() {
        List list = null;
        List list2 = null;
        List list3 = null;
        String string = HttpUrlExtensionsKt.toJwksUrl(this.url).toString();
        String string2 = HttpUrlExtensionsKt.toEndSessionEndpointUrl(this.url).toString();
        String string3 = HttpUrlExtensionsKt.toTokenEndpointUrl(this.url).toString();
        return new WellKnown(HttpUrlExtensionsKt.toIssuerUrl(this.url).toString(), HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.url).toString(), string2, string3, string, list3, list2, list, 224, null);
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final HttpUrl getUrl() {
        return this.url;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    public OAuth2HttpRequest(@NotNull Headers headers, @NotNull String method, @NotNull HttpUrl url, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.headers = headers;
        this.method = method;
        this.url = url;
        this.body = body;
        this.formParameters = new Parameters(this.body);
        Object object = this.headers.get("Cookie");
        if (object == null || (object = StringKt.keyValuesToMap((String)object, ";")) == null) {
            object = MapsKt.emptyMap();
        }
        this.cookies = object;
    }

    public /* synthetic */ OAuth2HttpRequest(Headers headers, String string, HttpUrl httpUrl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(headers, string, httpUrl, string2);
    }

    @NotNull
    public final Headers component1() {
        return this.headers;
    }

    @NotNull
    public final String component2() {
        return this.method;
    }

    @NotNull
    public final HttpUrl component3() {
        return this.url;
    }

    @Nullable
    public final String component4() {
        return this.body;
    }

    @NotNull
    public final OAuth2HttpRequest copy(@NotNull Headers headers, @NotNull String method, @NotNull HttpUrl url, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new OAuth2HttpRequest(headers, method, url, body);
    }

    public static /* synthetic */ OAuth2HttpRequest copy$default(OAuth2HttpRequest oAuth2HttpRequest, Headers headers, String string, HttpUrl httpUrl, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            headers = oAuth2HttpRequest.headers;
        }
        if ((n & 2) != 0) {
            string = oAuth2HttpRequest.method;
        }
        if ((n & 4) != 0) {
            httpUrl = oAuth2HttpRequest.url;
        }
        if ((n & 8) != 0) {
            string2 = oAuth2HttpRequest.body;
        }
        return oAuth2HttpRequest.copy(headers, string, httpUrl, string2);
    }

    @NotNull
    public String toString() {
        return "OAuth2HttpRequest(headers=" + this.headers + ", method=" + this.method + ", url=" + this.url + ", body=" + this.body + ")";
    }

    public int hashCode() {
        Headers headers = this.headers;
        String string = this.method;
        HttpUrl httpUrl = this.url;
        String string2 = this.body;
        return (((headers != null ? headers.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (httpUrl != null ? httpUrl.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof OAuth2HttpRequest)) break block3;
                OAuth2HttpRequest oAuth2HttpRequest = (OAuth2HttpRequest)object;
                if (!Intrinsics.areEqual((Object)this.headers, (Object)oAuth2HttpRequest.headers) || !Intrinsics.areEqual((Object)this.method, (Object)oAuth2HttpRequest.method) || !Intrinsics.areEqual((Object)this.url, (Object)oAuth2HttpRequest.url) || !Intrinsics.areEqual((Object)this.body, (Object)oAuth2HttpRequest.body)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "", "parameterString", "", "(Ljava/lang/String;)V", "map", "", "getMap", "()Ljava/util/Map;", "getParameterString", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "get", "name", "hashCode", "", "toString", "mock-oauth2-server"})
    public static final class Parameters {
        @NotNull
        private final Map<String, String> map;
        @Nullable
        private final String parameterString;

        @NotNull
        public final Map<String, String> getMap() {
            return this.map;
        }

        @Nullable
        public final String get(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.map.get(name);
        }

        @Nullable
        public final String getParameterString() {
            return this.parameterString;
        }

        public Parameters(@Nullable String parameterString) {
            this.parameterString = parameterString;
            Object object = this.parameterString;
            if (object == null || (object = StringKt.keyValuesToMap((String)object, "&")) == null) {
                object = MapsKt.emptyMap();
            }
            this.map = object;
        }

        @Nullable
        public final String component1() {
            return this.parameterString;
        }

        @NotNull
        public final Parameters copy(@Nullable String parameterString) {
            return new Parameters(parameterString);
        }

        public static /* synthetic */ Parameters copy$default(Parameters parameters, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameters.parameterString;
            }
            return parameters.copy(string);
        }

        @NotNull
        public String toString() {
            return "Parameters(parameterString=" + this.parameterString + ")";
        }

        public int hashCode() {
            String string = this.parameterString;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameters)) break block3;
                    Parameters parameters = (Parameters)object;
                    if (!Intrinsics.areEqual((Object)this.parameterString, (Object)parameters.parameterString)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

