/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JT\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "", "()V", "jwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "rsaKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "accessToken", "Lcom/nimbusds/jwt/SignedJWT;", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "nonce", "", "createSignedJWT", "claimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "defaultClaims", "kotlin.jvm.PlatformType", "subject", "audience", "", "additionalClaims", "", "expiry", "", "exchangeAccessToken", "idToken", "publicJwkSet", "Companion", "mock-oauth2-server"})
public final class OAuth2TokenProvider {
    private final JWKSet jwkSet = no.nav.security.mock.oauth2.token.OAuth2TokenProvider$Companion.access$generateJWKSet(Companion, "mock-oauth2-server-key");
    private final RSAKey rsaKey;
    private static final String DEFAULT_KEYID = "mock-oauth2-server-key";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JWKSet publicJwkSet() {
        JWKSet jWKSet = this.jwkSet.toPublicJWKSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWKSet, (String)"jwkSet.toPublicJWKSet()");
        return jWKSet;
    }

    @NotNull
    public final SignedJWT idToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), CollectionsKt.listOf((Object)NimbusExtensionsKt.clientIdAsString(tokenRequest)), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(\n         \u2026k.tokenExpiry()\n        )");
        return this.createSignedJWT(jWTClaimsSet);
    }

    public static /* synthetic */ SignedJWT idToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.idToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT accessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), oAuth2TokenCallback.audience(tokenRequest), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(\n         \u2026k.tokenExpiry()\n        )");
        return this.createSignedJWT(jWTClaimsSet);
    }

    public static /* synthetic */ SignedJWT accessToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.accessToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT exchangeAccessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull JWTClaimsSet claimsSet, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)claimsSet, (String)"claimsSet");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        Instant instant = Instant.now();
        boolean bl = false;
        boolean bl2 = false;
        Instant now = instant;
        boolean bl3 = false;
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder(claimsSet).issuer(issuerUrl.toString()).expirationTime(Date.from(now.plusSeconds(oAuth2TokenCallback.tokenExpiry()))).notBeforeTime(Date.from(now)).issueTime(Date.from(now)).jwtID(UUID.randomUUID().toString()).audience(oAuth2TokenCallback.audience(tokenRequest)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"JWTClaimsSet.Builder(cla\u2026\n                .build()");
        return this.createSignedJWT(jWTClaimsSet);
    }

    private final SignedJWT createSignedJWT(JWTClaimsSet claimsSet) {
        JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.rsaKey.getKeyID()).type(JOSEObjectType.JWT);
        SignedJWT signedJWT = new SignedJWT(header.build(), claimsSet);
        RSASSASigner signer = new RSASSASigner(this.rsaKey.toPrivateKey());
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    private final JWTClaimsSet defaultClaims(HttpUrl issuerUrl, String subject, List<String> audience, String nonce, Map<String, ? extends Object> additionalClaims, long expiry) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        boolean bl = false;
        boolean bl2 = false;
        JWTClaimsSet.Builder builder2 = builder;
        boolean bl3 = false;
        Instant now = Instant.now();
        builder2.subject(subject).audience(audience).issuer(issuerUrl.toString()).issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry))).jwtID(UUID.randomUUID().toString());
        String string = nonce;
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            builder2.claim("nonce", (Object)it);
        }
        Map<String, ? extends Object> $this$forEach$iv = additionalClaims;
        boolean $i$f$forEach = false;
        Map<String, ? extends Object> map = $this$forEach$iv;
        boolean bl7 = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> it = element$iv = iterator.next();
            boolean bl8 = false;
            builder2.claim(it.getKey(), it.getValue());
        }
        return builder2.build();
    }

    public OAuth2TokenProvider() {
        JWK jWK = this.jwkSet.getKeyByKeyId(DEFAULT_KEYID);
        if (jWK == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.nimbusds.jose.jwk.RSAKey");
        }
        this.rsaKey = (RSAKey)jWK;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider$Companion;", "", "()V", "DEFAULT_KEYID", "", "createRSAKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "kotlin.jvm.PlatformType", "keyID", "keyPair", "Ljava/security/KeyPair;", "generateJWKSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "keyId", "generateKeyPair", "mock-oauth2-server"})
    public static final class Companion {
        private final JWKSet generateJWKSet(String keyId) {
            return new JWKSet((JWK)this.createRSAKey(keyId, this.generateKeyPair()));
        }

        private final KeyPair generateKeyPair() {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            boolean bl = false;
            boolean bl2 = false;
            KeyPairGenerator it = keyPairGenerator;
            boolean bl3 = false;
            it.initialize(2048);
            KeyPair keyPair = it.generateKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"KeyPairGenerator.getInst\u2026teKeyPair()\n            }");
            return keyPair;
        }

        private final RSAKey createRSAKey(String keyID, KeyPair keyPair) {
            PublicKey publicKey = keyPair.getPublic();
            if (publicKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
            }
            PrivateKey privateKey = keyPair.getPrivate();
            if (privateKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
            }
            return new RSAKey.Builder((RSAPublicKey)publicKey).privateKey((RSAPrivateKey)privateKey).keyUse(KeyUse.SIGNATURE).keyID(keyID).build();
        }

        private Companion() {
        }

        public static final /* synthetic */ JWKSet access$generateJWKSet(Companion $this, String keyId) {
            return $this.generateJWKSet(keyId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

