/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lno/nav/security/mock/oauth2/grant/JwtBearerGrantHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;)V", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "assertion", "Lcom/nimbusds/jwt/JWTClaimsSet;", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "responseScope", "", "mock-oauth2-server"})
public final class JwtBearerGrantHandler
implements GrantHandler {
    private final OAuth2TokenProvider tokenProvider;

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asNimbusTokenRequest();
        JWTClaimsSet receivedClaimsSet = this.assertion(tokenRequest);
        SignedJWT accessToken = this.tokenProvider.exchangeAccessToken(tokenRequest, issuerUrl, receivedClaimsSet, oAuth2TokenCallback);
        return new OAuth2TokenResponse("Bearer", null, null, accessToken.serialize(), null, NimbusExtensionsKt.expiresIn(accessToken), this.responseScope(tokenRequest), 22, null);
    }

    private final String responseScope(TokenRequest $this$responseScope) {
        Object object = $this$responseScope.getScope();
        if (object == null || (object = object.toString()) == null) {
            Object object2 = this.assertion($this$responseScope).getClaim("scope");
            object = object2 != null ? object2.toString() : null;
        }
        if (object == null) {
            Void void_ = OAuth2ExceptionKt.invalidRequest("scope must be specified in request or as a claim in assertion parameter");
            throw new KotlinNothingValueException();
        }
        return object;
    }

    private final JWTClaimsSet assertion(TokenRequest $this$assertion) {
        JWTBearerGrant jWTBearerGrant;
        AuthorizationGrant authorizationGrant = $this$assertion.getAuthorizationGrant();
        if (!(authorizationGrant instanceof JWTBearerGrant)) {
            authorizationGrant = null;
        }
        if ((jWTBearerGrant = (JWTBearerGrant)authorizationGrant) == null || (jWTBearerGrant = jWTBearerGrant.getJWTAssertion()) == null || (jWTBearerGrant = jWTBearerGrant.getJWTClaimsSet()) == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter assertion");
        }
        return jWTBearerGrant;
    }

    public JwtBearerGrantHandler(@NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        this.tokenProvider = tokenProvider;
    }
}

