/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.extensions;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0018\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00070\u00070\u0016*\u00020\u0002\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0002\u001a\u001a\u0010\u001a\u001a\u00020\u001b*\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u00a8\u0006 "}, d2={"authorizationCode", "Lcom/nimbusds/oauth2/sdk/AuthorizationCode;", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "clientAuthentication", "Lcom/nimbusds/oauth2/sdk/auth/ClientAuthentication;", "Lcom/nimbusds/oauth2/sdk/http/HTTPRequest;", "clientIdAsString", "", "expiresIn", "", "Lcom/nimbusds/jwt/SignedJWT;", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "isPrompt", "", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "requirePrivateKeyJwt", "Lcom/nimbusds/oauth2/sdk/auth/PrivateKeyJWT;", "requiredAudience", "maxLifetimeSeconds", "", "scopesWithoutOidcScopes", "", "kotlin.jvm.PlatformType", "tokenExchangeGrantOrNull", "Lno/nav/security/mock/oauth2/grant/TokenExchangeGrant;", "verifySignatureAndIssuer", "Lcom/nimbusds/jwt/JWTClaimsSet;", "issuer", "Lcom/nimbusds/oauth2/sdk/id/Issuer;", "jwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "mock-oauth2-server"})
public final class NimbusExtensionsKt {
    public static final boolean isPrompt(@NotNull AuthenticationRequest $this$isPrompt) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$isPrompt, (String)"$this$isPrompt");
            Prompt prompt = $this$isPrompt.getPrompt();
            if (prompt != null) {
                Iterable $this$any$iv = (Iterable)prompt;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Prompt.Type it = (Prompt.Type)element$iv;
                        boolean bl2 = false;
                        if (!(it == Prompt.Type.LOGIN || it == Prompt.Type.CONSENT || it == Prompt.Type.SELECT_ACCOUNT)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final GrantType grantType(@NotNull TokenRequest $this$grantType) {
        Intrinsics.checkNotNullParameter((Object)$this$grantType, (String)"$this$grantType");
        AuthorizationGrant authorizationGrant = $this$grantType.getAuthorizationGrant();
        if (authorizationGrant == null || (authorizationGrant = authorizationGrant.getType()) == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter grant_type");
        }
        return authorizationGrant;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> scopesWithoutOidcScopes(@NotNull TokenRequest $this$scopesWithoutOidcScopes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$scopesWithoutOidcScopes, (String)"$this$scopesWithoutOidcScopes");
        Object object = $this$scopesWithoutOidcScopes.getScope();
        if (object != null && (object = object.toStringList()) != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = (Iterable)object;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                void $this$mapTo$iv$iv;
                OIDCScopeValue[] $this$map$iv;
                String value = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)OIDCScopeValue.values(), (String)"OIDCScopeValue.values()");
                boolean $i$f$map = false;
                OIDCScopeValue[] oIDCScopeValueArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var15_15 = $this$mapTo$iv$iv;
                int n = ((void)var15_15).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var19_19 = item$iv$iv = var15_15[i];
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String string = it.toString();
                    collection.add(string);
                }
                if (((List)destination$iv$iv2).contains(value)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final TokenExchangeGrant tokenExchangeGrantOrNull(@NotNull TokenRequest $this$tokenExchangeGrantOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenExchangeGrantOrNull, (String)"$this$tokenExchangeGrantOrNull");
        AuthorizationGrant authorizationGrant = $this$tokenExchangeGrantOrNull.getAuthorizationGrant();
        if (!(authorizationGrant instanceof TokenExchangeGrant)) {
            authorizationGrant = null;
        }
        return (TokenExchangeGrant)authorizationGrant;
    }

    @NotNull
    public static final AuthorizationCode authorizationCode(@NotNull TokenRequest $this$authorizationCode) {
        AuthorizationGrant authorizationGrant;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$authorizationCode, (String)"$this$authorizationCode");
                authorizationGrant = $this$authorizationCode.getAuthorizationGrant();
                if (authorizationGrant == null) break block4;
                AuthorizationGrant authorizationGrant2 = authorizationGrant;
                boolean bl = false;
                boolean bl2 = false;
                AuthorizationGrant it = authorizationGrant2;
                boolean bl3 = false;
                AuthorizationGrant authorizationGrant3 = it;
                if (!(authorizationGrant3 instanceof AuthorizationCodeGrant)) {
                    authorizationGrant3 = null;
                }
                if ((authorizationGrant = (AuthorizationCodeGrant)authorizationGrant3) != null && (authorizationGrant = authorizationGrant.getAuthorizationCode()) != null) break block5;
            }
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_GRANT, "code cannot be null");
        }
        return authorizationGrant;
    }

    @NotNull
    public static final String clientIdAsString(@NotNull TokenRequest $this$clientIdAsString) {
        Intrinsics.checkNotNullParameter((Object)$this$clientIdAsString, (String)"$this$clientIdAsString");
        Object object = $this$clientIdAsString.getClientAuthentication();
        if (object == null || (object = object.getClientID()) == null || (object = object.getValue()) == null) {
            ClientID clientID = $this$clientIdAsString.getClientID();
            object = clientID != null ? clientID.getValue() : null;
        }
        if (object == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_CLIENT, "client_id cannot be null");
        }
        return object;
    }

    public static final int expiresIn(@NotNull SignedJWT $this$expiresIn) {
        Intrinsics.checkNotNullParameter((Object)$this$expiresIn, (String)"$this$expiresIn");
        Temporal temporal = Instant.now();
        JWTClaimsSet jWTClaimsSet = $this$expiresIn.getJWTClaimsSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"this.jwtClaimsSet");
        Duration duration = Duration.between(temporal, jWTClaimsSet.getExpirationTime().toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.between(Instant\u2026pirationTime.toInstant())");
        return (int)duration.getSeconds();
    }

    @NotNull
    public static final JWTClaimsSet verifySignatureAndIssuer(@NotNull SignedJWT $this$verifySignatureAndIssuer, @NotNull Issuer issuer, @NotNull JWKSet jwkSet) {
        JWTClaimsSet jWTClaimsSet;
        Intrinsics.checkNotNullParameter((Object)$this$verifySignatureAndIssuer, (String)"$this$verifySignatureAndIssuer");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)jwkSet, (String)"jwkSet");
        ConfigurableJWTProcessor jwtProcessor = (ConfigurableJWTProcessor)new DefaultJWTProcessor();
        jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("JWT")}));
        JWSKeySelector keySelector = (JWSKeySelector)new JWSVerificationKeySelector(JWSAlgorithm.RS256, (JWKSource)new ImmutableJWKSet(jwkSet));
        jwtProcessor.setJWSKeySelector(keySelector);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer.toString()).build(), (Set)new HashSet(CollectionsKt.listOf((Object[])new String[]{"sub", "iat", "exp", "aud"}))));
        try {
            JWTClaimsSet jWTClaimsSet2 = jwtProcessor.process($this$verifySignatureAndIssuer, null);
            Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet2, (String)"jwtProcessor.process(this, null)");
            jWTClaimsSet = jWTClaimsSet2;
        }
        catch (Exception e) {
            throw (Throwable)new OAuth2Exception("invalid signed JWT.", e);
        }
        return jWTClaimsSet;
    }

    @NotNull
    public static final ClientAuthentication clientAuthentication(@NotNull HTTPRequest $this$clientAuthentication) {
        Intrinsics.checkNotNullParameter((Object)$this$clientAuthentication, (String)"$this$clientAuthentication");
        ClientAuthentication clientAuthentication = ClientAuthentication.parse((HTTPRequest)$this$clientAuthentication);
        if (clientAuthentication == null) {
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "request must contain some form of ClientAuthentication.");
        }
        return clientAuthentication;
    }

    @NotNull
    public static final PrivateKeyJWT requirePrivateKeyJwt(@NotNull ClientAuthentication $this$requirePrivateKeyJwt, @NotNull String requiredAudience, long maxLifetimeSeconds) {
        PrivateKeyJWT privateKeyJWT;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)$this$requirePrivateKeyJwt, (String)"$this$requirePrivateKeyJwt");
                Intrinsics.checkNotNullParameter((Object)requiredAudience, (String)"requiredAudience");
                ClientAuthentication clientAuthentication = $this$requirePrivateKeyJwt;
                if (!(clientAuthentication instanceof PrivateKeyJWT)) {
                    clientAuthentication = null;
                }
                if ((privateKeyJWT = (PrivateKeyJWT)clientAuthentication) == null) break block6;
                PrivateKeyJWT privateKeyJWT2 = privateKeyJWT;
                boolean bl = false;
                boolean bl2 = false;
                PrivateKeyJWT it = privateKeyJWT2;
                boolean bl3 = false;
                SignedJWT signedJWT = it.getClientAssertion();
                Intrinsics.checkNotNullExpressionValue((Object)signedJWT, (String)"it.clientAssertion");
                if ((long)NimbusExtensionsKt.expiresIn(signedJWT) > maxLifetimeSeconds) {
                    Void void_ = OAuth2ExceptionKt.invalidRequest("invalid client_assertion: client_assertion expiry is too long( should be < " + maxLifetimeSeconds + ')');
                    throw new KotlinNothingValueException();
                }
                SignedJWT signedJWT2 = it.getClientAssertion();
                Intrinsics.checkNotNullExpressionValue((Object)signedJWT2, (String)"it.clientAssertion");
                JWTClaimsSet jWTClaimsSet = signedJWT2.getJWTClaimsSet();
                Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"it.clientAssertion.jwtClaimsSet");
                if (!jWTClaimsSet.getAudience().contains(requiredAudience)) {
                    Void void_ = OAuth2ExceptionKt.invalidRequest("invalid client_assertion: client_assertion must contain required audience '" + requiredAudience + '\'');
                    throw new KotlinNothingValueException();
                }
                PrivateKeyJWT privateKeyJWT3 = it;
                privateKeyJWT = privateKeyJWT3;
                if (privateKeyJWT3 != null) break block7;
            }
            throw (Throwable)new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "request must contain a valid client_assertion.");
        }
        return privateKeyJWT;
    }
}

