/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenGrantHandlerKt;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lno/nav/security/mock/oauth2/grant/RefreshTokenGrantHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;)V", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "refreshTokenGrant", "Lcom/nimbusds/oauth2/sdk/RefreshTokenGrant;", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "mock-oauth2-server"})
public final class RefreshTokenGrantHandler
implements GrantHandler {
    private final OAuth2TokenProvider tokenProvider;
    private final RefreshTokenManager refreshTokenManager;

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asNimbusTokenRequest();
        RefreshToken refreshToken = this.refreshTokenGrant(tokenRequest).getRefreshToken();
        Intrinsics.checkNotNullExpressionValue((Object)refreshToken, (String)"tokenRequest.refreshTokenGrant().refreshToken");
        String refreshToken2 = refreshToken.getValue();
        RefreshTokenGrantHandlerKt.access$getLog$p().debug("issuing token for refreshToken=" + refreshToken2);
        Scope scope = tokenRequest.getScope();
        String scope2 = scope != null ? scope.toString() : null;
        String string = refreshToken2;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"refreshToken");
        OAuth2TokenCallback oAuth2TokenCallback2 = this.refreshTokenManager.get(string);
        if (oAuth2TokenCallback2 == null) {
            oAuth2TokenCallback2 = oAuth2TokenCallback;
        }
        OAuth2TokenCallback refreshTokenCallbackOrDefault = oAuth2TokenCallback2;
        SignedJWT idToken = OAuth2TokenProvider.idToken$default(this.tokenProvider, tokenRequest, issuerUrl, refreshTokenCallbackOrDefault, null, 8, null);
        SignedJWT accessToken = OAuth2TokenProvider.accessToken$default(this.tokenProvider, tokenRequest, issuerUrl, refreshTokenCallbackOrDefault, null, 8, null);
        return new OAuth2TokenResponse("Bearer", null, idToken.serialize(), accessToken.serialize(), refreshToken2, NimbusExtensionsKt.expiresIn(idToken), scope2, 2, null);
    }

    private final RefreshTokenGrant refreshTokenGrant(TokenRequest $this$refreshTokenGrant) {
        AuthorizationGrant authorizationGrant = $this$refreshTokenGrant.getAuthorizationGrant();
        if (!(authorizationGrant instanceof RefreshTokenGrant)) {
            authorizationGrant = null;
        }
        RefreshTokenGrant refreshTokenGrant = (RefreshTokenGrant)authorizationGrant;
        if (refreshTokenGrant == null) {
            GrantType grantType = GrantType.REFRESH_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)grantType, (String)"GrantType.REFRESH_TOKEN");
            Void void_ = OAuth2ExceptionKt.invalidGrant(grantType);
            throw new KotlinNothingValueException();
        }
        return refreshTokenGrant;
    }

    public RefreshTokenGrantHandler(@NotNull OAuth2TokenProvider tokenProvider, @NotNull RefreshTokenManager refreshTokenManager) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter((Object)refreshTokenManager, (String)"refreshTokenManager");
        this.tokenProvider = tokenProvider;
        this.refreshTokenManager = refreshTokenManager;
    }
}

