/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import java.net.InetAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.RecordedRequestExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpServer;
import no.nav.security.mock.oauth2.http.OAuth2HttpServerKt;
import no.nav.security.mock.oauth2.http.Ssl;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0013\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lno/nav/security/mock/oauth2/http/MockWebServerWrapper;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "ssl", "Lno/nav/security/mock/oauth2/http/Ssl;", "(Lno/nav/security/mock/oauth2/http/Ssl;)V", "mockWebServer", "Lokhttp3/mockwebserver/MockWebServer;", "getMockWebServer", "()Lokhttp3/mockwebserver/MockWebServer;", "getSsl", "()Lno/nav/security/mock/oauth2/http/Ssl;", "port", "", "start", "inetAddress", "Ljava/net/InetAddress;", "requestHandler", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "stop", "url", "Lokhttp3/HttpUrl;", "path", "", "MockWebServerDispatcher", "mock-oauth2-server"})
public final class MockWebServerWrapper
implements OAuth2HttpServer {
    @NotNull
    private final MockWebServer mockWebServer;
    @Nullable
    private final Ssl ssl;

    @NotNull
    public final MockWebServer getMockWebServer() {
        return this.mockWebServer;
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(@NotNull InetAddress inetAddress, int port, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        MockWebServerWrapper mockWebServerWrapper = this;
        boolean bl = false;
        boolean bl2 = false;
        MockWebServerWrapper $this$apply = mockWebServerWrapper;
        boolean bl3 = false;
        $this$apply.mockWebServer.start(inetAddress, port);
        $this$apply.mockWebServer.setDispatcher((Dispatcher)new MockWebServerDispatcher(requestHandler, null, 2, null));
        if ($this$apply.ssl != null) {
            MockWebServer mockWebServer = $this$apply.mockWebServer;
            SSLSocketFactory sSLSocketFactory = $this$apply.ssl.sslContext().getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"ssl.sslContext().socketFactory");
            mockWebServer.useHttps(sSLSocketFactory, false);
        }
        OAuth2HttpServerKt.access$getLog$p().debug("started server on address=" + inetAddress + " and port=" + $this$apply.mockWebServer.getPort() + ", httpsEnabled=" + ($this$apply.ssl != null));
        return mockWebServerWrapper;
    }

    @Override
    @NotNull
    public OAuth2HttpServer stop() {
        MockWebServerWrapper mockWebServerWrapper = this;
        boolean bl = false;
        boolean bl2 = false;
        MockWebServerWrapper $this$apply = mockWebServerWrapper;
        boolean bl3 = false;
        $this$apply.mockWebServer.shutdown();
        return mockWebServerWrapper;
    }

    @Override
    public int port() {
        return this.mockWebServer.getPort();
    }

    @Override
    @NotNull
    public HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.mockWebServer.url(path);
    }

    @Nullable
    public final Ssl getSsl() {
        return this.ssl;
    }

    @JvmOverloads
    public MockWebServerWrapper(@Nullable Ssl ssl) {
        this.ssl = ssl;
        this.mockWebServer = new MockWebServer();
    }

    public /* synthetic */ MockWebServerWrapper(Ssl ssl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ssl = null;
        }
        this(ssl);
    }

    @JvmOverloads
    public MockWebServerWrapper() {
        this(null, 1, null);
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(@NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpServer.DefaultImpls.start(this, requestHandler);
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(int port, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpServer.DefaultImpls.start(this, port, requestHandler);
    }

    @Override
    public void close() {
        OAuth2HttpServer.DefaultImpls.close(this);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\t*\u00020\u0005H\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lno/nav/security/mock/oauth2/http/MockWebServerWrapper$MockWebServerDispatcher;", "Lokhttp3/mockwebserver/Dispatcher;", "requestHandler", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "responseQueue", "Ljava/util/concurrent/BlockingQueue;", "Lokhttp3/mockwebserver/MockResponse;", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/BlockingQueue;)V", "dispatch", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "toMockResponse", "mock-oauth2-server"})
    public static final class MockWebServerDispatcher
    extends Dispatcher {
        private final Function1<OAuth2HttpRequest, OAuth2HttpResponse> requestHandler;
        private final BlockingQueue<MockResponse> responseQueue;

        @NotNull
        public MockResponse dispatch(@NotNull RecordedRequest request) {
            MockResponse mockResponse;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    mockResponse = (MockResponse)this.responseQueue.peek();
                    if (mockResponse == null) break block2;
                    MockResponse mockResponse2 = mockResponse;
                    boolean bl = false;
                    boolean bl2 = false;
                    MockResponse it = mockResponse2;
                    boolean bl3 = false;
                    mockResponse = this.responseQueue.take();
                    if (mockResponse != null) break block3;
                }
                mockResponse = this.toMockResponse((OAuth2HttpResponse)this.requestHandler.invoke((Object)RecordedRequestExtensionsKt.asOAuth2HttpRequest(request)));
            }
            return mockResponse;
        }

        private final MockResponse toMockResponse(OAuth2HttpResponse $this$toMockResponse) {
            MockResponse mockResponse = new MockResponse().setHeaders($this$toMockResponse.getHeaders()).setResponseCode($this$toMockResponse.getStatus());
            boolean bl = false;
            boolean bl2 = false;
            MockResponse it = mockResponse;
            boolean bl3 = false;
            return $this$toMockResponse.getBody() != null ? it.setBody($this$toMockResponse.getBody()) : it.setBody("");
        }

        public MockWebServerDispatcher(@NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler, @NotNull BlockingQueue<MockResponse> responseQueue) {
            Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
            Intrinsics.checkNotNullParameter(responseQueue, (String)"responseQueue");
            this.requestHandler = requestHandler;
            this.responseQueue = responseQueue;
        }

        public /* synthetic */ MockWebServerDispatcher(Function1 function1, BlockingQueue blockingQueue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                blockingQueue = new LinkedBlockingQueue();
            }
            this((Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)function1, blockingQueue);
        }
    }
}

